/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.ModelSnapshot;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetModelSnapshotsResponse
implements JsonpSerializable {
    private final long count;
    private final List<ModelSnapshot> modelSnapshots;
    public static final JsonpDeserializer<GetModelSnapshotsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetModelSnapshotsResponse::setupGetModelSnapshotsResponseDeserializer, Builder::build);

    public GetModelSnapshotsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.modelSnapshots = ModelTypeHelper.unmodifiableNonNull(builder.modelSnapshots, "model_snapshots");
    }

    public GetModelSnapshotsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<ModelSnapshot> modelSnapshots() {
        return this.modelSnapshots;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("model_snapshots");
        generator.writeStartArray();
        for (ModelSnapshot item0 : this.modelSnapshots) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetModelSnapshotsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::modelSnapshots, JsonpDeserializer.arrayDeserializer(ModelSnapshot._DESERIALIZER), "model_snapshots", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetModelSnapshotsResponse> {
        private Long count;
        private List<ModelSnapshot> modelSnapshots;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder modelSnapshots(List<ModelSnapshot> value) {
            this.modelSnapshots = value;
            return this;
        }

        public Builder modelSnapshots(ModelSnapshot ... value) {
            this.modelSnapshots = Arrays.asList(value);
            return this;
        }

        public Builder addModelSnapshots(ModelSnapshot value) {
            if (this.modelSnapshots == null) {
                this.modelSnapshots = new ArrayList<ModelSnapshot>();
            }
            this.modelSnapshots.add(value);
            return this;
        }

        public Builder modelSnapshots(Function<ModelSnapshot.Builder, ObjectBuilder<ModelSnapshot>> fn) {
            return this.modelSnapshots(fn.apply(new ModelSnapshot.Builder()).build());
        }

        public Builder addModelSnapshots(Function<ModelSnapshot.Builder, ObjectBuilder<ModelSnapshot>> fn) {
            return this.addModelSnapshots(fn.apply(new ModelSnapshot.Builder()).build());
        }

        @Override
        public GetModelSnapshotsResponse build() {
            return new GetModelSnapshotsResponse(this);
        }
    }
}

