/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Anomaly;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetRecordsResponse
implements JsonpSerializable {
    private final long count;
    private final List<Anomaly> records;
    public static final JsonpDeserializer<GetRecordsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetRecordsResponse::setupGetRecordsResponseDeserializer, Builder::build);

    public GetRecordsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.records = ModelTypeHelper.unmodifiableNonNull(builder.records, "records");
    }

    public GetRecordsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<Anomaly> records() {
        return this.records;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("records");
        generator.writeStartArray();
        for (Anomaly item0 : this.records) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetRecordsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::records, JsonpDeserializer.arrayDeserializer(Anomaly._DESERIALIZER), "records", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetRecordsResponse> {
        private Long count;
        private List<Anomaly> records;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder records(List<Anomaly> value) {
            this.records = value;
            return this;
        }

        public Builder records(Anomaly ... value) {
            this.records = Arrays.asList(value);
            return this;
        }

        public Builder addRecords(Anomaly value) {
            if (this.records == null) {
                this.records = new ArrayList<Anomaly>();
            }
            this.records.add(value);
            return this;
        }

        public Builder records(Function<Anomaly.Builder, ObjectBuilder<Anomaly>> fn) {
            return this.records(fn.apply(new Anomaly.Builder()).build());
        }

        public Builder addRecords(Function<Anomaly.Builder, ObjectBuilder<Anomaly>> fn) {
            return this.addRecords(fn.apply(new Anomaly.Builder()).build());
        }

        @Override
        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }
    }
}

