/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class StartDatafeedResponse
implements JsonpSerializable {
    private final List<String> node;
    private final boolean started;
    public static final JsonpDeserializer<StartDatafeedResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StartDatafeedResponse::setupStartDatafeedResponseDeserializer, Builder::build);

    public StartDatafeedResponse(Builder builder) {
        this.node = ModelTypeHelper.unmodifiableNonNull(builder.node, "node");
        this.started = Objects.requireNonNull(builder.started, "started");
    }

    public StartDatafeedResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> node() {
        return this.node;
    }

    public boolean started() {
        return this.started;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node");
        generator.writeStartArray();
        for (String item0 : this.node) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("started");
        generator.write(this.started);
    }

    protected static void setupStartDatafeedResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::node, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "node", new String[0]);
        op.add(Builder::started, JsonpDeserializer.booleanDeserializer(), "started", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StartDatafeedResponse> {
        private List<String> node;
        private Boolean started;

        public Builder node(List<String> value) {
            this.node = value;
            return this;
        }

        public Builder node(String ... value) {
            this.node = Arrays.asList(value);
            return this;
        }

        public Builder addNode(String value) {
            if (this.node == null) {
                this.node = new ArrayList<String>();
            }
            this.node.add(value);
            return this;
        }

        public Builder started(boolean value) {
            this.started = value;
            return this;
        }

        @Override
        public StartDatafeedResponse build() {
            return new StartDatafeedResponse(this);
        }
    }
}

