/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.aggregations.InferenceConfig;
import co.elastic.clients.elasticsearch.ml.TrainedModelConfigInput;
import co.elastic.clients.elasticsearch.ml.TrainedModelConfigMetadata;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TrainedModelConfig
implements JsonpSerializable {
    private final String modelId;
    private final List<String> tags;
    @Nullable
    private final String version;
    @Nullable
    private final String compressedDefinition;
    @Nullable
    private final String createdBy;
    @Nullable
    private final String createTime;
    @Nullable
    private final Map<String, String> defaultFieldMap;
    @Nullable
    private final String description;
    @Nullable
    private final Integer estimatedHeapMemoryUsageBytes;
    @Nullable
    private final Integer estimatedOperations;
    private final InferenceConfig inferenceConfig;
    private final TrainedModelConfigInput input;
    @Nullable
    private final String licenseLevel;
    @Nullable
    private final TrainedModelConfigMetadata metadata;
    public static final JsonpDeserializer<TrainedModelConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelConfig::setupTrainedModelConfigDeserializer, Builder::build);

    public TrainedModelConfig(Builder builder) {
        this.modelId = Objects.requireNonNull(builder.modelId, "model_id");
        this.tags = ModelTypeHelper.unmodifiableNonNull(builder.tags, "tags");
        this.version = builder.version;
        this.compressedDefinition = builder.compressedDefinition;
        this.createdBy = builder.createdBy;
        this.createTime = builder.createTime;
        this.defaultFieldMap = ModelTypeHelper.unmodifiable(builder.defaultFieldMap);
        this.description = builder.description;
        this.estimatedHeapMemoryUsageBytes = builder.estimatedHeapMemoryUsageBytes;
        this.estimatedOperations = builder.estimatedOperations;
        this.inferenceConfig = Objects.requireNonNull(builder.inferenceConfig, "inference_config");
        this.input = Objects.requireNonNull(builder.input, "input");
        this.licenseLevel = builder.licenseLevel;
        this.metadata = builder.metadata;
    }

    public TrainedModelConfig(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String modelId() {
        return this.modelId;
    }

    public List<String> tags() {
        return this.tags;
    }

    @Nullable
    public String version() {
        return this.version;
    }

    @Nullable
    public String compressedDefinition() {
        return this.compressedDefinition;
    }

    @Nullable
    public String createdBy() {
        return this.createdBy;
    }

    @Nullable
    public String createTime() {
        return this.createTime;
    }

    @Nullable
    public Map<String, String> defaultFieldMap() {
        return this.defaultFieldMap;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public Integer estimatedHeapMemoryUsageBytes() {
        return this.estimatedHeapMemoryUsageBytes;
    }

    @Nullable
    public Integer estimatedOperations() {
        return this.estimatedOperations;
    }

    public InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public TrainedModelConfigInput input() {
        return this.input;
    }

    @Nullable
    public String licenseLevel() {
        return this.licenseLevel;
    }

    @Nullable
    public TrainedModelConfigMetadata metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("tags");
        generator.writeStartArray();
        for (String string : this.tags) {
            generator.write(string);
        }
        generator.writeEnd();
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.compressedDefinition != null) {
            generator.writeKey("compressed_definition");
            generator.write(this.compressedDefinition);
        }
        if (this.createdBy != null) {
            generator.writeKey("created_by");
            generator.write(this.createdBy);
        }
        if (this.createTime != null) {
            generator.writeKey("create_time");
            generator.write(this.createTime);
        }
        if (this.defaultFieldMap != null) {
            generator.writeKey("default_field_map");
            generator.writeStartObject();
            for (Map.Entry entry : this.defaultFieldMap.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.estimatedHeapMemoryUsageBytes != null) {
            generator.writeKey("estimated_heap_memory_usage_bytes");
            generator.write(this.estimatedHeapMemoryUsageBytes.intValue());
        }
        if (this.estimatedOperations != null) {
            generator.writeKey("estimated_operations");
            generator.write(this.estimatedOperations.intValue());
        }
        generator.writeKey("inference_config");
        this.inferenceConfig.serialize(generator, mapper);
        generator.writeKey("input");
        this.input.serialize(generator, mapper);
        if (this.licenseLevel != null) {
            generator.writeKey("license_level");
            generator.write(this.licenseLevel);
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            this.metadata.serialize(generator, mapper);
        }
    }

    protected static void setupTrainedModelConfigDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id", new String[0]);
        op.add(Builder::tags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tags", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::compressedDefinition, JsonpDeserializer.stringDeserializer(), "compressed_definition", new String[0]);
        op.add(Builder::createdBy, JsonpDeserializer.stringDeserializer(), "created_by", new String[0]);
        op.add(Builder::createTime, JsonpDeserializer.stringDeserializer(), "create_time", new String[0]);
        op.add(Builder::defaultFieldMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "default_field_map", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::estimatedHeapMemoryUsageBytes, JsonpDeserializer.integerDeserializer(), "estimated_heap_memory_usage_bytes", new String[0]);
        op.add(Builder::estimatedOperations, JsonpDeserializer.integerDeserializer(), "estimated_operations", new String[0]);
        op.add(Builder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config", new String[0]);
        op.add(Builder::input, TrainedModelConfigInput._DESERIALIZER, "input", new String[0]);
        op.add(Builder::licenseLevel, JsonpDeserializer.stringDeserializer(), "license_level", new String[0]);
        op.add(Builder::metadata, TrainedModelConfigMetadata._DESERIALIZER, "metadata", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TrainedModelConfig> {
        private String modelId;
        private List<String> tags;
        @Nullable
        private String version;
        @Nullable
        private String compressedDefinition;
        @Nullable
        private String createdBy;
        @Nullable
        private String createTime;
        @Nullable
        private Map<String, String> defaultFieldMap;
        @Nullable
        private String description;
        @Nullable
        private Integer estimatedHeapMemoryUsageBytes;
        @Nullable
        private Integer estimatedOperations;
        private InferenceConfig inferenceConfig;
        private TrainedModelConfigInput input;
        @Nullable
        private String licenseLevel;
        @Nullable
        private TrainedModelConfigMetadata metadata;

        public Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public Builder tags(List<String> value) {
            this.tags = value;
            return this;
        }

        public Builder tags(String ... value) {
            this.tags = Arrays.asList(value);
            return this;
        }

        public Builder addTags(String value) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(value);
            return this;
        }

        public Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public Builder compressedDefinition(@Nullable String value) {
            this.compressedDefinition = value;
            return this;
        }

        public Builder createdBy(@Nullable String value) {
            this.createdBy = value;
            return this;
        }

        public Builder createTime(@Nullable String value) {
            this.createTime = value;
            return this;
        }

        public Builder defaultFieldMap(@Nullable Map<String, String> value) {
            this.defaultFieldMap = value;
            return this;
        }

        public Builder putDefaultFieldMap(String key, String value) {
            if (this.defaultFieldMap == null) {
                this.defaultFieldMap = new HashMap<String, String>();
            }
            this.defaultFieldMap.put(key, value);
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder estimatedHeapMemoryUsageBytes(@Nullable Integer value) {
            this.estimatedHeapMemoryUsageBytes = value;
            return this;
        }

        public Builder estimatedOperations(@Nullable Integer value) {
            this.estimatedOperations = value;
            return this;
        }

        public Builder inferenceConfig(InferenceConfig value) {
            this.inferenceConfig = value;
            return this;
        }

        public Builder inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        public Builder input(TrainedModelConfigInput value) {
            this.input = value;
            return this;
        }

        public Builder input(Function<TrainedModelConfigInput.Builder, ObjectBuilder<TrainedModelConfigInput>> fn) {
            return this.input(fn.apply(new TrainedModelConfigInput.Builder()).build());
        }

        public Builder licenseLevel(@Nullable String value) {
            this.licenseLevel = value;
            return this;
        }

        public Builder metadata(@Nullable TrainedModelConfigMetadata value) {
            this.metadata = value;
            return this;
        }

        public Builder metadata(Function<TrainedModelConfigMetadata.Builder, ObjectBuilder<TrainedModelConfigMetadata>> fn) {
            return this.metadata(fn.apply(new TrainedModelConfigMetadata.Builder()).build());
        }

        @Override
        public TrainedModelConfig build() {
            return new TrainedModelConfig(this);
        }
    }
}

