/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Hyperparameter;
import co.elastic.clients.elasticsearch.ml.TotalFeatureImportance;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class TrainedModelConfigMetadata
implements JsonpSerializable {
    @Nullable
    private final List<String> modelAliases;
    @Nullable
    private final Map<String, String> featureImportanceBaseline;
    @Nullable
    private final List<Hyperparameter> hyperparameters;
    @Nullable
    private final List<TotalFeatureImportance> totalFeatureImportance;
    public static final JsonpDeserializer<TrainedModelConfigMetadata> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelConfigMetadata::setupTrainedModelConfigMetadataDeserializer, Builder::build);

    public TrainedModelConfigMetadata(Builder builder) {
        this.modelAliases = ModelTypeHelper.unmodifiable(builder.modelAliases);
        this.featureImportanceBaseline = ModelTypeHelper.unmodifiable(builder.featureImportanceBaseline);
        this.hyperparameters = ModelTypeHelper.unmodifiable(builder.hyperparameters);
        this.totalFeatureImportance = ModelTypeHelper.unmodifiable(builder.totalFeatureImportance);
    }

    public TrainedModelConfigMetadata(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> modelAliases() {
        return this.modelAliases;
    }

    @Nullable
    public Map<String, String> featureImportanceBaseline() {
        return this.featureImportanceBaseline;
    }

    @Nullable
    public List<Hyperparameter> hyperparameters() {
        return this.hyperparameters;
    }

    @Nullable
    public List<TotalFeatureImportance> totalFeatureImportance() {
        return this.totalFeatureImportance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.modelAliases != null) {
            generator.writeKey("model_aliases");
            generator.writeStartArray();
            for (String string : this.modelAliases) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.featureImportanceBaseline != null) {
            generator.writeKey("feature_importance_baseline");
            generator.writeStartObject();
            for (Map.Entry entry : this.featureImportanceBaseline.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.hyperparameters != null) {
            generator.writeKey("hyperparameters");
            generator.writeStartArray();
            for (Hyperparameter hyperparameter : this.hyperparameters) {
                hyperparameter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalFeatureImportance != null) {
            generator.writeKey("total_feature_importance");
            generator.writeStartArray();
            for (TotalFeatureImportance totalFeatureImportance : this.totalFeatureImportance) {
                totalFeatureImportance.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTrainedModelConfigMetadataDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::modelAliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "model_aliases", new String[0]);
        op.add(Builder::featureImportanceBaseline, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "feature_importance_baseline", new String[0]);
        op.add(Builder::hyperparameters, JsonpDeserializer.arrayDeserializer(Hyperparameter._DESERIALIZER), "hyperparameters", new String[0]);
        op.add(Builder::totalFeatureImportance, JsonpDeserializer.arrayDeserializer(TotalFeatureImportance._DESERIALIZER), "total_feature_importance", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TrainedModelConfigMetadata> {
        @Nullable
        private List<String> modelAliases;
        @Nullable
        private Map<String, String> featureImportanceBaseline;
        @Nullable
        private List<Hyperparameter> hyperparameters;
        @Nullable
        private List<TotalFeatureImportance> totalFeatureImportance;

        public Builder modelAliases(@Nullable List<String> value) {
            this.modelAliases = value;
            return this;
        }

        public Builder modelAliases(String ... value) {
            this.modelAliases = Arrays.asList(value);
            return this;
        }

        public Builder addModelAliases(String value) {
            if (this.modelAliases == null) {
                this.modelAliases = new ArrayList<String>();
            }
            this.modelAliases.add(value);
            return this;
        }

        public Builder featureImportanceBaseline(@Nullable Map<String, String> value) {
            this.featureImportanceBaseline = value;
            return this;
        }

        public Builder putFeatureImportanceBaseline(String key, String value) {
            if (this.featureImportanceBaseline == null) {
                this.featureImportanceBaseline = new HashMap<String, String>();
            }
            this.featureImportanceBaseline.put(key, value);
            return this;
        }

        public Builder hyperparameters(@Nullable List<Hyperparameter> value) {
            this.hyperparameters = value;
            return this;
        }

        public Builder hyperparameters(Hyperparameter ... value) {
            this.hyperparameters = Arrays.asList(value);
            return this;
        }

        public Builder addHyperparameters(Hyperparameter value) {
            if (this.hyperparameters == null) {
                this.hyperparameters = new ArrayList<Hyperparameter>();
            }
            this.hyperparameters.add(value);
            return this;
        }

        public Builder hyperparameters(Function<Hyperparameter.Builder, ObjectBuilder<Hyperparameter>> fn) {
            return this.hyperparameters(fn.apply(new Hyperparameter.Builder()).build());
        }

        public Builder addHyperparameters(Function<Hyperparameter.Builder, ObjectBuilder<Hyperparameter>> fn) {
            return this.addHyperparameters(fn.apply(new Hyperparameter.Builder()).build());
        }

        public Builder totalFeatureImportance(@Nullable List<TotalFeatureImportance> value) {
            this.totalFeatureImportance = value;
            return this;
        }

        public Builder totalFeatureImportance(TotalFeatureImportance ... value) {
            this.totalFeatureImportance = Arrays.asList(value);
            return this;
        }

        public Builder addTotalFeatureImportance(TotalFeatureImportance value) {
            if (this.totalFeatureImportance == null) {
                this.totalFeatureImportance = new ArrayList<TotalFeatureImportance>();
            }
            this.totalFeatureImportance.add(value);
            return this;
        }

        public Builder totalFeatureImportance(Function<TotalFeatureImportance.Builder, ObjectBuilder<TotalFeatureImportance>> fn) {
            return this.totalFeatureImportance(fn.apply(new TotalFeatureImportance.Builder()).build());
        }

        public Builder addTotalFeatureImportance(Function<TotalFeatureImportance.Builder, ObjectBuilder<TotalFeatureImportance>> fn) {
            return this.addTotalFeatureImportance(fn.apply(new TotalFeatureImportance.Builder()).build());
        }

        @Override
        public TrainedModelConfigMetadata build() {
            return new TrainedModelConfigMetadata(this);
        }
    }
}

