/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.ConfusionMatrixPrediction;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ConfusionMatrixItem
implements JsonpSerializable {
    private final String actualClass;
    private final int actualClassDocCount;
    private final List<ConfusionMatrixPrediction> predictedClasses;
    private final int otherPredictedClassDocCount;
    public static final JsonpDeserializer<ConfusionMatrixItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConfusionMatrixItem::setupConfusionMatrixItemDeserializer, Builder::build);

    public ConfusionMatrixItem(Builder builder) {
        this.actualClass = Objects.requireNonNull(builder.actualClass, "actual_class");
        this.actualClassDocCount = Objects.requireNonNull(builder.actualClassDocCount, "actual_class_doc_count");
        this.predictedClasses = ModelTypeHelper.unmodifiableNonNull(builder.predictedClasses, "predicted_classes");
        this.otherPredictedClassDocCount = Objects.requireNonNull(builder.otherPredictedClassDocCount, "other_predicted_class_doc_count");
    }

    public ConfusionMatrixItem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String actualClass() {
        return this.actualClass;
    }

    public int actualClassDocCount() {
        return this.actualClassDocCount;
    }

    public List<ConfusionMatrixPrediction> predictedClasses() {
        return this.predictedClasses;
    }

    public int otherPredictedClassDocCount() {
        return this.otherPredictedClassDocCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actual_class");
        generator.write(this.actualClass);
        generator.writeKey("actual_class_doc_count");
        generator.write(this.actualClassDocCount);
        generator.writeKey("predicted_classes");
        generator.writeStartArray();
        for (ConfusionMatrixPrediction item0 : this.predictedClasses) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("other_predicted_class_doc_count");
        generator.write(this.otherPredictedClassDocCount);
    }

    protected static void setupConfusionMatrixItemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actualClass, JsonpDeserializer.stringDeserializer(), "actual_class", new String[0]);
        op.add(Builder::actualClassDocCount, JsonpDeserializer.integerDeserializer(), "actual_class_doc_count", new String[0]);
        op.add(Builder::predictedClasses, JsonpDeserializer.arrayDeserializer(ConfusionMatrixPrediction._DESERIALIZER), "predicted_classes", new String[0]);
        op.add(Builder::otherPredictedClassDocCount, JsonpDeserializer.integerDeserializer(), "other_predicted_class_doc_count", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ConfusionMatrixItem> {
        private String actualClass;
        private Integer actualClassDocCount;
        private List<ConfusionMatrixPrediction> predictedClasses;
        private Integer otherPredictedClassDocCount;

        public Builder actualClass(String value) {
            this.actualClass = value;
            return this;
        }

        public Builder actualClassDocCount(int value) {
            this.actualClassDocCount = value;
            return this;
        }

        public Builder predictedClasses(List<ConfusionMatrixPrediction> value) {
            this.predictedClasses = value;
            return this;
        }

        public Builder predictedClasses(ConfusionMatrixPrediction ... value) {
            this.predictedClasses = Arrays.asList(value);
            return this;
        }

        public Builder addPredictedClasses(ConfusionMatrixPrediction value) {
            if (this.predictedClasses == null) {
                this.predictedClasses = new ArrayList<ConfusionMatrixPrediction>();
            }
            this.predictedClasses.add(value);
            return this;
        }

        public Builder predictedClasses(Function<ConfusionMatrixPrediction.Builder, ObjectBuilder<ConfusionMatrixPrediction>> fn) {
            return this.predictedClasses(fn.apply(new ConfusionMatrixPrediction.Builder()).build());
        }

        public Builder addPredictedClasses(Function<ConfusionMatrixPrediction.Builder, ObjectBuilder<ConfusionMatrixPrediction>> fn) {
            return this.addPredictedClasses(fn.apply(new ConfusionMatrixPrediction.Builder()).build());
        }

        public Builder otherPredictedClassDocCount(int value) {
            this.otherPredictedClassDocCount = value;
            return this;
        }

        @Override
        public ConfusionMatrixItem build() {
            return new ConfusionMatrixItem(this);
        }
    }
}

