/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeBufferPool
implements JsonpSerializable {
    private final long count;
    private final String totalCapacity;
    private final long totalCapacityInBytes;
    private final String used;
    private final long usedInBytes;
    public static final JsonpDeserializer<NodeBufferPool> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeBufferPool::setupNodeBufferPoolDeserializer, Builder::build);

    public NodeBufferPool(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.totalCapacity = Objects.requireNonNull(builder.totalCapacity, "total_capacity");
        this.totalCapacityInBytes = Objects.requireNonNull(builder.totalCapacityInBytes, "total_capacity_in_bytes");
        this.used = Objects.requireNonNull(builder.used, "used");
        this.usedInBytes = Objects.requireNonNull(builder.usedInBytes, "used_in_bytes");
    }

    public NodeBufferPool(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public String totalCapacity() {
        return this.totalCapacity;
    }

    public long totalCapacityInBytes() {
        return this.totalCapacityInBytes;
    }

    public String used() {
        return this.used;
    }

    public long usedInBytes() {
        return this.usedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("total_capacity");
        generator.write(this.totalCapacity);
        generator.writeKey("total_capacity_in_bytes");
        generator.write(this.totalCapacityInBytes);
        generator.writeKey("used");
        generator.write(this.used);
        generator.writeKey("used_in_bytes");
        generator.write(this.usedInBytes);
    }

    protected static void setupNodeBufferPoolDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::totalCapacity, JsonpDeserializer.stringDeserializer(), "total_capacity", new String[0]);
        op.add(Builder::totalCapacityInBytes, JsonpDeserializer.longDeserializer(), "total_capacity_in_bytes", new String[0]);
        op.add(Builder::used, JsonpDeserializer.stringDeserializer(), "used", new String[0]);
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeBufferPool> {
        private Long count;
        private String totalCapacity;
        private Long totalCapacityInBytes;
        private String used;
        private Long usedInBytes;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder totalCapacity(String value) {
            this.totalCapacity = value;
            return this;
        }

        public Builder totalCapacityInBytes(long value) {
            this.totalCapacityInBytes = value;
            return this;
        }

        public Builder used(String value) {
            this.used = value;
            return this;
        }

        public Builder usedInBytes(long value) {
            this.usedInBytes = value;
            return this;
        }

        @Override
        public NodeBufferPool build() {
            return new NodeBufferPool(this);
        }
    }
}

