/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Scripting
implements JsonpSerializable {
    private final long cacheEvictions;
    private final long compilations;
    public static final JsonpDeserializer<Scripting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Scripting::setupScriptingDeserializer, Builder::build);

    public Scripting(Builder builder) {
        this.cacheEvictions = Objects.requireNonNull(builder.cacheEvictions, "cache_evictions");
        this.compilations = Objects.requireNonNull(builder.compilations, "compilations");
    }

    public Scripting(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long cacheEvictions() {
        return this.cacheEvictions;
    }

    public long compilations() {
        return this.compilations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_evictions");
        generator.write(this.cacheEvictions);
        generator.writeKey("compilations");
        generator.write(this.compilations);
    }

    protected static void setupScriptingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cacheEvictions, JsonpDeserializer.longDeserializer(), "cache_evictions", new String[0]);
        op.add(Builder::compilations, JsonpDeserializer.longDeserializer(), "compilations", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Scripting> {
        private Long cacheEvictions;
        private Long compilations;

        public Builder cacheEvictions(long value) {
            this.cacheEvictions = value;
            return this;
        }

        public Builder compilations(long value) {
            this.compilations = value;
            return this;
        }

        @Override
        public Scripting build() {
            return new Scripting(this);
        }
    }
}

