/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeInfoBootstrap
implements JsonpSerializable {
    private final String memoryLock;
    public static final JsonpDeserializer<NodeInfoBootstrap> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoBootstrap::setupNodeInfoBootstrapDeserializer, Builder::build);

    public NodeInfoBootstrap(Builder builder) {
        this.memoryLock = Objects.requireNonNull(builder.memoryLock, "memory_lock");
    }

    public NodeInfoBootstrap(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String memoryLock() {
        return this.memoryLock;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("memory_lock");
        generator.write(this.memoryLock);
    }

    protected static void setupNodeInfoBootstrapDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::memoryLock, JsonpDeserializer.stringDeserializer(), "memory_lock", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfoBootstrap> {
        private String memoryLock;

        public Builder memoryLock(String value) {
            this.memoryLock = value;
            return this;
        }

        @Override
        public NodeInfoBootstrap build() {
            return new NodeInfoBootstrap(this);
        }
    }
}

