/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_jobs;

import co.elastic.clients.elasticsearch.rollup.FieldMetric;
import co.elastic.clients.elasticsearch.rollup.Groupings;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RollupJobConfiguration
implements JsonpSerializable {
    private final String cron;
    private final Groupings groups;
    private final String id;
    private final String indexPattern;
    private final List<FieldMetric> metrics;
    private final long pageSize;
    private final String rollupIndex;
    private final String timeout;
    public static final JsonpDeserializer<RollupJobConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJobConfiguration::setupRollupJobConfigurationDeserializer, Builder::build);

    public RollupJobConfiguration(Builder builder) {
        this.cron = Objects.requireNonNull(builder.cron, "cron");
        this.groups = Objects.requireNonNull(builder.groups, "groups");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.indexPattern = Objects.requireNonNull(builder.indexPattern, "index_pattern");
        this.metrics = ModelTypeHelper.unmodifiableNonNull(builder.metrics, "metrics");
        this.pageSize = Objects.requireNonNull(builder.pageSize, "page_size");
        this.rollupIndex = Objects.requireNonNull(builder.rollupIndex, "rollup_index");
        this.timeout = Objects.requireNonNull(builder.timeout, "timeout");
    }

    public RollupJobConfiguration(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String cron() {
        return this.cron;
    }

    public Groupings groups() {
        return this.groups;
    }

    public String id() {
        return this.id;
    }

    public String indexPattern() {
        return this.indexPattern;
    }

    public List<FieldMetric> metrics() {
        return this.metrics;
    }

    public long pageSize() {
        return this.pageSize;
    }

    public String rollupIndex() {
        return this.rollupIndex;
    }

    public String timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cron");
        generator.write(this.cron);
        generator.writeKey("groups");
        this.groups.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("index_pattern");
        generator.write(this.indexPattern);
        generator.writeKey("metrics");
        generator.writeStartArray();
        for (FieldMetric item0 : this.metrics) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("page_size");
        generator.write(this.pageSize);
        generator.writeKey("rollup_index");
        generator.write(this.rollupIndex);
        generator.writeKey("timeout");
        generator.write(this.timeout);
    }

    protected static void setupRollupJobConfigurationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cron, JsonpDeserializer.stringDeserializer(), "cron", new String[0]);
        op.add(Builder::groups, Groupings._DESERIALIZER, "groups", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::indexPattern, JsonpDeserializer.stringDeserializer(), "index_pattern", new String[0]);
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(FieldMetric._DESERIALIZER), "metrics", new String[0]);
        op.add(Builder::pageSize, JsonpDeserializer.longDeserializer(), "page_size", new String[0]);
        op.add(Builder::rollupIndex, JsonpDeserializer.stringDeserializer(), "rollup_index", new String[0]);
        op.add(Builder::timeout, JsonpDeserializer.stringDeserializer(), "timeout", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RollupJobConfiguration> {
        private String cron;
        private Groupings groups;
        private String id;
        private String indexPattern;
        private List<FieldMetric> metrics;
        private Long pageSize;
        private String rollupIndex;
        private String timeout;

        public Builder cron(String value) {
            this.cron = value;
            return this;
        }

        public Builder groups(Groupings value) {
            this.groups = value;
            return this;
        }

        public Builder groups(Function<Groupings.Builder, ObjectBuilder<Groupings>> fn) {
            return this.groups(fn.apply(new Groupings.Builder()).build());
        }

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder indexPattern(String value) {
            this.indexPattern = value;
            return this;
        }

        public Builder metrics(List<FieldMetric> value) {
            this.metrics = value;
            return this;
        }

        public Builder metrics(FieldMetric ... value) {
            this.metrics = Arrays.asList(value);
            return this;
        }

        public Builder addMetrics(FieldMetric value) {
            if (this.metrics == null) {
                this.metrics = new ArrayList<FieldMetric>();
            }
            this.metrics.add(value);
            return this;
        }

        public Builder metrics(Function<FieldMetric.Builder, ObjectBuilder<FieldMetric>> fn) {
            return this.metrics(fn.apply(new FieldMetric.Builder()).build());
        }

        public Builder addMetrics(Function<FieldMetric.Builder, ObjectBuilder<FieldMetric>> fn) {
            return this.addMetrics(fn.apply(new FieldMetric.Builder()).build());
        }

        public Builder pageSize(long value) {
            this.pageSize = value;
            return this;
        }

        public Builder rollupIndex(String value) {
            this.rollupIndex = value;
            return this;
        }

        public Builder timeout(String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public RollupJobConfiguration build() {
            return new RollupJobConfiguration(this);
        }
    }
}

