/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_rollup_index_caps;

import co.elastic.clients.elasticsearch.rollup.get_rollup_index_caps.RollupJobSummaryField;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RollupJobSummary
implements JsonpSerializable {
    private final Map<String, List<RollupJobSummaryField>> fields;
    private final String indexPattern;
    private final String jobId;
    private final String rollupIndex;
    public static final JsonpDeserializer<RollupJobSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJobSummary::setupRollupJobSummaryDeserializer, Builder::build);

    public RollupJobSummary(Builder builder) {
        this.fields = ModelTypeHelper.unmodifiableNonNull(builder.fields, "fields");
        this.indexPattern = Objects.requireNonNull(builder.indexPattern, "index_pattern");
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.rollupIndex = Objects.requireNonNull(builder.rollupIndex, "rollup_index");
    }

    public RollupJobSummary(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, List<RollupJobSummaryField>> fields() {
        return this.fields;
    }

    public String indexPattern() {
        return this.indexPattern;
    }

    public String jobId() {
        return this.jobId;
    }

    public String rollupIndex() {
        return this.rollupIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fields");
        generator.writeStartObject();
        for (Map.Entry<String, List<RollupJobSummaryField>> item0 : this.fields.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartArray();
            for (RollupJobSummaryField item1 : item0.getValue()) {
                item1.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("index_pattern");
        generator.write(this.indexPattern);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("rollup_index");
        generator.write(this.rollupIndex);
    }

    protected static void setupRollupJobSummaryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(RollupJobSummaryField._DESERIALIZER)), "fields", new String[0]);
        op.add(Builder::indexPattern, JsonpDeserializer.stringDeserializer(), "index_pattern", new String[0]);
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id", new String[0]);
        op.add(Builder::rollupIndex, JsonpDeserializer.stringDeserializer(), "rollup_index", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RollupJobSummary> {
        private Map<String, List<RollupJobSummaryField>> fields;
        private String indexPattern;
        private String jobId;
        private String rollupIndex;

        public Builder fields(Map<String, List<RollupJobSummaryField>> value) {
            this.fields = value;
            return this;
        }

        public Builder putFields(String key, List<RollupJobSummaryField> value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, List<RollupJobSummaryField>>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder indexPattern(String value) {
            this.indexPattern = value;
            return this;
        }

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder rollupIndex(String value) {
            this.rollupIndex = value;
            return this;
        }

        @Override
        public RollupJobSummary build() {
            return new RollupJobSummary(this);
        }
    }
}

