/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ApplicationPrivileges
implements JsonpSerializable {
    private final String application;
    private final List<String> privileges;
    private final List<String> resources;
    public static final JsonpDeserializer<ApplicationPrivileges> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApplicationPrivileges::setupApplicationPrivilegesDeserializer, Builder::build);

    public ApplicationPrivileges(Builder builder) {
        this.application = Objects.requireNonNull(builder.application, "application");
        this.privileges = ModelTypeHelper.unmodifiableNonNull(builder.privileges, "privileges");
        this.resources = ModelTypeHelper.unmodifiableNonNull(builder.resources, "resources");
    }

    public ApplicationPrivileges(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String application() {
        return this.application;
    }

    public List<String> privileges() {
        return this.privileges;
    }

    public List<String> resources() {
        return this.resources;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("application");
        generator.write(this.application);
        generator.writeKey("privileges");
        generator.writeStartArray();
        for (String item0 : this.privileges) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("resources");
        generator.writeStartArray();
        for (String item0 : this.resources) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupApplicationPrivilegesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::application, JsonpDeserializer.stringDeserializer(), "application", new String[0]);
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "privileges", new String[0]);
        op.add(Builder::resources, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "resources", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ApplicationPrivileges> {
        private String application;
        private List<String> privileges;
        private List<String> resources;

        public Builder application(String value) {
            this.application = value;
            return this;
        }

        public Builder privileges(List<String> value) {
            this.privileges = value;
            return this;
        }

        public Builder privileges(String ... value) {
            this.privileges = Arrays.asList(value);
            return this;
        }

        public Builder addPrivileges(String value) {
            if (this.privileges == null) {
                this.privileges = new ArrayList<String>();
            }
            this.privileges.add(value);
            return this;
        }

        public Builder resources(List<String> value) {
            this.resources = value;
            return this;
        }

        public Builder resources(String ... value) {
            this.resources = Arrays.asList(value);
            return this;
        }

        public Builder addResources(String value) {
            if (this.resources == null) {
                this.resources = new ArrayList<String>();
            }
            this.resources.add(value);
            return this;
        }

        @Override
        public ApplicationPrivileges build() {
            return new ApplicationPrivileges(this);
        }
    }
}

