/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class FieldSecurity
implements JsonpSerializable {
    @Nullable
    private final List<String> except;
    private final List<String> grant;
    public static final JsonpDeserializer<FieldSecurity> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldSecurity::setupFieldSecurityDeserializer, Builder::build);

    public FieldSecurity(Builder builder) {
        this.except = ModelTypeHelper.unmodifiable(builder.except);
        this.grant = ModelTypeHelper.unmodifiableNonNull(builder.grant, "grant");
    }

    public FieldSecurity(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> except() {
        return this.except;
    }

    public List<String> grant() {
        return this.grant;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.except != null) {
            generator.writeKey("except");
            generator.writeStartArray();
            for (String item0 : this.except) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("grant");
        generator.writeStartArray();
        for (String item0 : this.grant) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupFieldSecurityDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::except, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "except", new String[0]);
        op.add(Builder::grant, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "grant", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<FieldSecurity> {
        @Nullable
        private List<String> except;
        private List<String> grant;

        public Builder except(@Nullable List<String> value) {
            this.except = value;
            return this;
        }

        public Builder except(String ... value) {
            this.except = Arrays.asList(value);
            return this;
        }

        public Builder addExcept(String value) {
            if (this.except == null) {
                this.except = new ArrayList<String>();
            }
            this.except.add(value);
            return this;
        }

        public Builder grant(List<String> value) {
            this.grant = value;
            return this;
        }

        public Builder grant(String ... value) {
            this.grant = Arrays.asList(value);
            return this;
        }

        public Builder addGrant(String value) {
            if (this.grant == null) {
                this.grant = new ArrayList<String>();
            }
            this.grant.add(value);
            return this;
        }

        @Override
        public FieldSecurity build() {
            return new FieldSecurity(this);
        }
    }
}

