/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetTokenResponse;
import co.elastic.clients.elasticsearch.security.get_token.AccessTokenGrantType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetTokenRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final AccessTokenGrantType grantType;
    @Nullable
    private final String scope;
    @Nullable
    private final String password;
    @Nullable
    private final String kerberosTicket;
    @Nullable
    private final String refreshToken;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<GetTokenRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTokenRequest::setupGetTokenRequestDeserializer, Builder::build);
    public static final Endpoint<GetTokenRequest, GetTokenResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetTokenRequest, GetTokenResponse>(request -> "POST", request -> "/_security/oauth2/token", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, GetTokenResponse._DESERIALIZER);

    public GetTokenRequest(Builder builder) {
        this.grantType = builder.grantType;
        this.scope = builder.scope;
        this.password = builder.password;
        this.kerberosTicket = builder.kerberosTicket;
        this.refreshToken = builder.refreshToken;
        this.username = builder.username;
    }

    public GetTokenRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public AccessTokenGrantType grantType() {
        return this.grantType;
    }

    @Nullable
    public String scope() {
        return this.scope;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    @Nullable
    public String kerberosTicket() {
        return this.kerberosTicket;
    }

    @Nullable
    public String refreshToken() {
        return this.refreshToken;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.grantType != null) {
            generator.writeKey("grant_type");
            this.grantType.serialize(generator, mapper);
        }
        if (this.scope != null) {
            generator.writeKey("scope");
            generator.write(this.scope);
        }
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.kerberosTicket != null) {
            generator.writeKey("kerberos_ticket");
            generator.write(this.kerberosTicket);
        }
        if (this.refreshToken != null) {
            generator.writeKey("refresh_token");
            generator.write(this.refreshToken);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    protected static void setupGetTokenRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::grantType, AccessTokenGrantType._DESERIALIZER, "grant_type", new String[0]);
        op.add(Builder::scope, JsonpDeserializer.stringDeserializer(), "scope", new String[0]);
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password", new String[0]);
        op.add(Builder::kerberosTicket, JsonpDeserializer.stringDeserializer(), "kerberos_ticket", new String[0]);
        op.add(Builder::refreshToken, JsonpDeserializer.stringDeserializer(), "refresh_token", new String[0]);
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetTokenRequest> {
        @Nullable
        private AccessTokenGrantType grantType;
        @Nullable
        private String scope;
        @Nullable
        private String password;
        @Nullable
        private String kerberosTicket;
        @Nullable
        private String refreshToken;
        @Nullable
        private String username;

        public Builder grantType(@Nullable AccessTokenGrantType value) {
            this.grantType = value;
            return this;
        }

        public Builder scope(@Nullable String value) {
            this.scope = value;
            return this;
        }

        public Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        public Builder kerberosTicket(@Nullable String value) {
            this.kerberosTicket = value;
            return this;
        }

        public Builder refreshToken(@Nullable String value) {
            this.refreshToken = value;
            return this;
        }

        public Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        public GetTokenRequest build() {
            return new GetTokenRequest(this);
        }
    }
}

