/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.PutUserResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutUserRequest
extends RequestBase
implements JsonpSerializable {
    private final String username;
    @Nullable
    private final JsonValue refresh;
    @Nullable
    private final String email;
    @Nullable
    private final String fullName;
    @Nullable
    private final Map<String, JsonData> metadata;
    @Nullable
    private final String password;
    @Nullable
    private final String passwordHash;
    @Nullable
    private final List<String> roles;
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<PutUserRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutUserRequest::setupPutUserRequestDeserializer, Builder::build);
    public static final Endpoint<PutUserRequest, PutUserResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutUserRequest, PutUserResponse>(request -> "PUT", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", JsonpUtils.toString(request.refresh));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutUserResponse._DESERIALIZER);

    public PutUserRequest(Builder builder) {
        this.username = Objects.requireNonNull(builder.username, "username");
        this.refresh = builder.refresh;
        this.email = builder.email;
        this.fullName = builder.fullName;
        this.metadata = ModelTypeHelper.unmodifiable(builder.metadata);
        this.password = builder.password;
        this.passwordHash = builder.passwordHash;
        this.roles = ModelTypeHelper.unmodifiable(builder.roles);
        this.enabled = builder.enabled;
    }

    public PutUserRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String username() {
        return this.username;
    }

    @Nullable
    public JsonValue refresh() {
        return this.refresh;
    }

    @Nullable
    public String email() {
        return this.email;
    }

    @Nullable
    public String fullName() {
        return this.fullName;
    }

    @Nullable
    public Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    @Nullable
    public String passwordHash() {
        return this.passwordHash;
    }

    @Nullable
    public List<String> roles() {
        return this.roles;
    }

    @Nullable
    public Boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.email != null) {
            generator.writeKey("email");
            generator.write(this.email);
        }
        if (this.fullName != null) {
            generator.writeKey("full_name");
            generator.write(this.fullName);
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.passwordHash != null) {
            generator.writeKey("password_hash");
            generator.write(this.passwordHash);
        }
        if (this.roles != null) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String string : this.roles) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
    }

    protected static void setupPutUserRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::email, JsonpDeserializer.stringDeserializer(), "email", new String[0]);
        op.add(Builder::fullName, JsonpDeserializer.stringDeserializer(), "full_name", new String[0]);
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata", new String[0]);
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password", new String[0]);
        op.add(Builder::passwordHash, JsonpDeserializer.stringDeserializer(), "password_hash", new String[0]);
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles", new String[0]);
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutUserRequest> {
        private String username;
        @Nullable
        private JsonValue refresh;
        @Nullable
        private String email;
        @Nullable
        private String fullName;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private String password;
        @Nullable
        private String passwordHash;
        @Nullable
        private List<String> roles;
        @Nullable
        private Boolean enabled;

        public Builder username(String value) {
            this.username = value;
            return this;
        }

        public Builder refresh(@Nullable JsonValue value) {
            this.refresh = value;
            return this;
        }

        public Builder email(@Nullable String value) {
            this.email = value;
            return this;
        }

        public Builder fullName(@Nullable String value) {
            this.fullName = value;
            return this;
        }

        public Builder metadata(@Nullable Map<String, JsonData> value) {
            this.metadata = value;
            return this;
        }

        public Builder putMetadata(String key, JsonData value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, JsonData>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        public Builder passwordHash(@Nullable String value) {
            this.passwordHash = value;
            return this;
        }

        public Builder roles(@Nullable List<String> value) {
            this.roles = value;
            return this;
        }

        public Builder roles(String ... value) {
            this.roles = Arrays.asList(value);
            return this;
        }

        public Builder addRoles(String value) {
            if (this.roles == null) {
                this.roles = new ArrayList<String>();
            }
            this.roles.add(value);
            return this;
        }

        public Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Override
        public PutUserRequest build() {
            return new PutUserRequest(this);
        }
    }
}

