/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.create_api_key;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.create_api_key.IndexPrivileges;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RoleDescriptor
implements JsonpSerializable {
    private final List<String> cluster;
    private final List<IndexPrivileges> index;
    @Nullable
    private final List<ApplicationPrivileges> applications;
    public static final JsonpDeserializer<RoleDescriptor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleDescriptor::setupRoleDescriptorDeserializer, Builder::build);

    public RoleDescriptor(Builder builder) {
        this.cluster = ModelTypeHelper.unmodifiableNonNull(builder.cluster, "cluster");
        this.index = ModelTypeHelper.unmodifiableNonNull(builder.index, "index");
        this.applications = ModelTypeHelper.unmodifiable(builder.applications);
    }

    public RoleDescriptor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> cluster() {
        return this.cluster;
    }

    public List<IndexPrivileges> index() {
        return this.index;
    }

    @Nullable
    public List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster");
        generator.writeStartArray();
        for (String string : this.cluster) {
            generator.write(string);
        }
        generator.writeEnd();
        generator.writeKey("index");
        generator.writeStartArray();
        for (IndexPrivileges indexPrivileges : this.index) {
            indexPrivileges.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.applications != null) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRoleDescriptorDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster", new String[0]);
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(IndexPrivileges._DESERIALIZER), "index", new String[0]);
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RoleDescriptor> {
        private List<String> cluster;
        private List<IndexPrivileges> index;
        @Nullable
        private List<ApplicationPrivileges> applications;

        public Builder cluster(List<String> value) {
            this.cluster = value;
            return this;
        }

        public Builder cluster(String ... value) {
            this.cluster = Arrays.asList(value);
            return this;
        }

        public Builder addCluster(String value) {
            if (this.cluster == null) {
                this.cluster = new ArrayList<String>();
            }
            this.cluster.add(value);
            return this;
        }

        public Builder index(List<IndexPrivileges> value) {
            this.index = value;
            return this;
        }

        public Builder index(IndexPrivileges ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(IndexPrivileges value) {
            if (this.index == null) {
                this.index = new ArrayList<IndexPrivileges>();
            }
            this.index.add(value);
            return this;
        }

        public Builder index(Function<IndexPrivileges.Builder, ObjectBuilder<IndexPrivileges>> fn) {
            return this.index(fn.apply(new IndexPrivileges.Builder()).build());
        }

        public Builder addIndex(Function<IndexPrivileges.Builder, ObjectBuilder<IndexPrivileges>> fn) {
            return this.addIndex(fn.apply(new IndexPrivileges.Builder()).build());
        }

        public Builder applications(@Nullable List<ApplicationPrivileges> value) {
            this.applications = value;
            return this;
        }

        public Builder applications(ApplicationPrivileges ... value) {
            this.applications = Arrays.asList(value);
            return this;
        }

        public Builder addApplications(ApplicationPrivileges value) {
            if (this.applications == null) {
                this.applications = new ArrayList<ApplicationPrivileges>();
            }
            this.applications.add(value);
            return this;
        }

        public Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        public Builder addApplications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.addApplications(fn.apply(new ApplicationPrivileges.Builder()).build());
        }

        @Override
        public RoleDescriptor build() {
            return new RoleDescriptor(this);
        }
    }
}

