/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.elasticsearch.shutdown.get_node.NodeShutdownStatus;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class GetNodeResponse
implements JsonpSerializable {
    private final List<NodeShutdownStatus> nodes;
    public static final JsonpDeserializer<GetNodeResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetNodeResponse::setupGetNodeResponseDeserializer, Builder::build);

    public GetNodeResponse(Builder builder) {
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
    }

    public GetNodeResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<NodeShutdownStatus> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("nodes");
        generator.writeStartArray();
        for (NodeShutdownStatus item0 : this.nodes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetNodeResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodes, JsonpDeserializer.arrayDeserializer(NodeShutdownStatus._DESERIALIZER), "nodes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetNodeResponse> {
        private List<NodeShutdownStatus> nodes;

        public Builder nodes(List<NodeShutdownStatus> value) {
            this.nodes = value;
            return this;
        }

        public Builder nodes(NodeShutdownStatus ... value) {
            this.nodes = Arrays.asList(value);
            return this;
        }

        public Builder addNodes(NodeShutdownStatus value) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<NodeShutdownStatus>();
            }
            this.nodes.add(value);
            return this;
        }

        public Builder nodes(Function<NodeShutdownStatus.Builder, ObjectBuilder<NodeShutdownStatus>> fn) {
            return this.nodes(fn.apply(new NodeShutdownStatus.Builder()).build());
        }

        public Builder addNodes(Function<NodeShutdownStatus.Builder, ObjectBuilder<NodeShutdownStatus>> fn) {
            return this.addNodes(fn.apply(new NodeShutdownStatus.Builder()).build());
        }

        @Override
        public GetNodeResponse build() {
            return new GetNodeResponse(this);
        }
    }
}

