/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Invocation
implements JsonpSerializable {
    private final String snapshotName;
    private final String time;
    public static final JsonpDeserializer<Invocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Invocation::setupInvocationDeserializer, Builder::build);

    public Invocation(Builder builder) {
        this.snapshotName = Objects.requireNonNull(builder.snapshotName, "snapshot_name");
        this.time = Objects.requireNonNull(builder.time, "time");
    }

    public Invocation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String snapshotName() {
        return this.snapshotName;
    }

    public String time() {
        return this.time;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshot_name");
        generator.write(this.snapshotName);
        generator.writeKey("time");
        generator.write(this.time);
    }

    protected static void setupInvocationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::snapshotName, JsonpDeserializer.stringDeserializer(), "snapshot_name", new String[0]);
        op.add(Builder::time, JsonpDeserializer.stringDeserializer(), "time", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Invocation> {
        private String snapshotName;
        private String time;

        public Builder snapshotName(String value) {
            this.snapshotName = value;
            return this;
        }

        public Builder time(String value) {
            this.time = value;
            return this;
        }

        @Override
        public Invocation build() {
            return new Invocation(this);
        }
    }
}

