/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.CloneResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CloneRequest
extends RequestBase
implements JsonpSerializable {
    private final String repository;
    private final String snapshot;
    private final String targetSnapshot;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    private final String indices;
    public static final JsonpDeserializer<CloneRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloneRequest::setupCloneRequestDeserializer, Builder::build);
    public static final Endpoint<CloneRequest, CloneResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<CloneRequest, CloneResponse>(request -> "PUT", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int _targetSnapshot = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            buf.append("/_clone");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.targetSnapshot, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CloneResponse._DESERIALIZER);

    public CloneRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
        this.targetSnapshot = Objects.requireNonNull(builder.targetSnapshot, "target_snapshot");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.indices = Objects.requireNonNull(builder.indices, "indices");
    }

    public CloneRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String repository() {
        return this.repository;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public String targetSnapshot() {
        return this.targetSnapshot;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public String indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.write(this.indices);
    }

    protected static void setupCloneRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringDeserializer(), "indices", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CloneRequest> {
        private String repository;
        private String snapshot;
        private String targetSnapshot;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        private String indices;

        public Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public Builder targetSnapshot(String value) {
            this.targetSnapshot = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder indices(String value) {
            this.indices = value;
            return this;
        }

        @Override
        public CloneRequest build() {
            return new CloneRequest(this);
        }
    }
}

