/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.RepositorySettings;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Repository
implements JsonpSerializable {
    private final String type;
    @Nullable
    private final String uuid;
    private final RepositorySettings settings;
    public static final JsonpDeserializer<Repository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Repository::setupRepositoryDeserializer, Builder::build);

    public Repository(Builder builder) {
        this.type = Objects.requireNonNull(builder.type, "type");
        this.uuid = builder.uuid;
        this.settings = Objects.requireNonNull(builder.settings, "settings");
    }

    public Repository(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String type() {
        return this.type;
    }

    @Nullable
    public String uuid() {
        return this.uuid;
    }

    public RepositorySettings settings() {
        return this.settings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        if (this.uuid != null) {
            generator.writeKey("uuid");
            generator.write(this.uuid);
        }
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
    }

    protected static void setupRepositoryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
        op.add(Builder::uuid, JsonpDeserializer.stringDeserializer(), "uuid", new String[0]);
        op.add(Builder::settings, RepositorySettings._DESERIALIZER, "settings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Repository> {
        private String type;
        @Nullable
        private String uuid;
        private RepositorySettings settings;

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        public Builder uuid(@Nullable String value) {
            this.uuid = value;
            return this;
        }

        public Builder settings(RepositorySettings value) {
            this.settings = value;
            return this;
        }

        public Builder settings(Function<RepositorySettings.Builder, ObjectBuilder<RepositorySettings>> fn) {
            return this.settings(fn.apply(new RepositorySettings.Builder()).build());
        }

        @Override
        public Repository build() {
            return new Repository(this);
        }
    }
}

