/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ConditionVariant;
import co.elastic.clients.elasticsearch.watcher.Quantifier;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ArrayCompareCondition
implements ConditionVariant,
JsonpSerializable {
    private final String arrayPath;
    private final String comparison;
    private final String path;
    private final Quantifier quantifier;
    private final JsonData value;
    public static final JsonpDeserializer<ArrayCompareCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ArrayCompareCondition::setupArrayCompareConditionDeserializer, Builder::build);

    public ArrayCompareCondition(Builder builder) {
        this.arrayPath = Objects.requireNonNull(builder.arrayPath, "array_path");
        this.comparison = Objects.requireNonNull(builder.comparison, "comparison");
        this.path = Objects.requireNonNull(builder.path, "path");
        this.quantifier = Objects.requireNonNull(builder.quantifier, "quantifier");
        this.value = Objects.requireNonNull(builder.value, "value");
    }

    public ArrayCompareCondition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "array_compare";
    }

    public String arrayPath() {
        return this.arrayPath;
    }

    public String comparison() {
        return this.comparison;
    }

    public String path() {
        return this.path;
    }

    public Quantifier quantifier() {
        return this.quantifier;
    }

    public JsonData value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("array_path");
        generator.write(this.arrayPath);
        generator.writeKey("comparison");
        generator.write(this.comparison);
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("quantifier");
        this.quantifier.serialize(generator, mapper);
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
    }

    protected static void setupArrayCompareConditionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::arrayPath, JsonpDeserializer.stringDeserializer(), "array_path", new String[0]);
        op.add(Builder::comparison, JsonpDeserializer.stringDeserializer(), "comparison", new String[0]);
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path", new String[0]);
        op.add(Builder::quantifier, Quantifier._DESERIALIZER, "quantifier", new String[0]);
        op.add(Builder::value, JsonData._DESERIALIZER, "value", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ArrayCompareCondition> {
        private String arrayPath;
        private String comparison;
        private String path;
        private Quantifier quantifier;
        private JsonData value;

        public Builder arrayPath(String value) {
            this.arrayPath = value;
            return this;
        }

        public Builder comparison(String value) {
            this.comparison = value;
            return this;
        }

        public Builder path(String value) {
            this.path = value;
            return this;
        }

        public Builder quantifier(Quantifier value) {
            this.quantifier = value;
            return this;
        }

        public Builder value(JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        public ArrayCompareCondition build() {
            return new ArrayCompareCondition(this);
        }
    }
}

