/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ScheduleVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class HourlySchedule
implements ScheduleVariant,
JsonpSerializable {
    private final List<Integer> minute;
    public static final JsonpDeserializer<HourlySchedule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HourlySchedule::setupHourlyScheduleDeserializer, Builder::build);

    public HourlySchedule(Builder builder) {
        this.minute = ModelTypeHelper.unmodifiableNonNull(builder.minute, "minute");
    }

    public HourlySchedule(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "hourly";
    }

    public List<Integer> minute() {
        return this.minute;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("minute");
        generator.writeStartArray();
        for (Integer item0 : this.minute) {
            generator.write(item0.intValue());
        }
        generator.writeEnd();
    }

    protected static void setupHourlyScheduleDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::minute, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.integerDeserializer()), "minute", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HourlySchedule> {
        private List<Integer> minute;

        public Builder minute(List<Integer> value) {
            this.minute = value;
            return this;
        }

        public Builder minute(Integer ... value) {
            this.minute = Arrays.asList(value);
            return this;
        }

        public Builder addMinute(Integer value) {
            if (this.minute == null) {
                this.minute = new ArrayList<Integer>();
            }
            this.minute.add(value);
            return this;
        }

        @Override
        public HourlySchedule build() {
            return new HourlySchedule(this);
        }
    }
}

