/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.SlackAttachmentField;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SlackAttachment
implements JsonpSerializable {
    @Nullable
    private final String authorIcon;
    @Nullable
    private final String authorLink;
    private final String authorName;
    @Nullable
    private final String color;
    @Nullable
    private final String fallback;
    @Nullable
    private final List<SlackAttachmentField> fields;
    @Nullable
    private final String footer;
    @Nullable
    private final String footerIcon;
    @Nullable
    private final String imageUrl;
    @Nullable
    private final String pretext;
    @Nullable
    private final String text;
    @Nullable
    private final String thumbUrl;
    private final String title;
    @Nullable
    private final String titleLink;
    @Nullable
    private final String ts;
    public static final JsonpDeserializer<SlackAttachment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlackAttachment::setupSlackAttachmentDeserializer, Builder::build);

    public SlackAttachment(Builder builder) {
        this.authorIcon = builder.authorIcon;
        this.authorLink = builder.authorLink;
        this.authorName = Objects.requireNonNull(builder.authorName, "author_name");
        this.color = builder.color;
        this.fallback = builder.fallback;
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.footer = builder.footer;
        this.footerIcon = builder.footerIcon;
        this.imageUrl = builder.imageUrl;
        this.pretext = builder.pretext;
        this.text = builder.text;
        this.thumbUrl = builder.thumbUrl;
        this.title = Objects.requireNonNull(builder.title, "title");
        this.titleLink = builder.titleLink;
        this.ts = builder.ts;
    }

    public SlackAttachment(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String authorIcon() {
        return this.authorIcon;
    }

    @Nullable
    public String authorLink() {
        return this.authorLink;
    }

    public String authorName() {
        return this.authorName;
    }

    @Nullable
    public String color() {
        return this.color;
    }

    @Nullable
    public String fallback() {
        return this.fallback;
    }

    @Nullable
    public List<SlackAttachmentField> fields() {
        return this.fields;
    }

    @Nullable
    public String footer() {
        return this.footer;
    }

    @Nullable
    public String footerIcon() {
        return this.footerIcon;
    }

    @Nullable
    public String imageUrl() {
        return this.imageUrl;
    }

    @Nullable
    public String pretext() {
        return this.pretext;
    }

    @Nullable
    public String text() {
        return this.text;
    }

    @Nullable
    public String thumbUrl() {
        return this.thumbUrl;
    }

    public String title() {
        return this.title;
    }

    @Nullable
    public String titleLink() {
        return this.titleLink;
    }

    @Nullable
    public String ts() {
        return this.ts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.authorIcon != null) {
            generator.writeKey("author_icon");
            generator.write(this.authorIcon);
        }
        if (this.authorLink != null) {
            generator.writeKey("author_link");
            generator.write(this.authorLink);
        }
        generator.writeKey("author_name");
        generator.write(this.authorName);
        if (this.color != null) {
            generator.writeKey("color");
            generator.write(this.color);
        }
        if (this.fallback != null) {
            generator.writeKey("fallback");
            generator.write(this.fallback);
        }
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (SlackAttachmentField item0 : this.fields) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.footer != null) {
            generator.writeKey("footer");
            generator.write(this.footer);
        }
        if (this.footerIcon != null) {
            generator.writeKey("footer_icon");
            generator.write(this.footerIcon);
        }
        if (this.imageUrl != null) {
            generator.writeKey("image_url");
            generator.write(this.imageUrl);
        }
        if (this.pretext != null) {
            generator.writeKey("pretext");
            generator.write(this.pretext);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
        if (this.thumbUrl != null) {
            generator.writeKey("thumb_url");
            generator.write(this.thumbUrl);
        }
        generator.writeKey("title");
        generator.write(this.title);
        if (this.titleLink != null) {
            generator.writeKey("title_link");
            generator.write(this.titleLink);
        }
        if (this.ts != null) {
            generator.writeKey("ts");
            generator.write(this.ts);
        }
    }

    protected static void setupSlackAttachmentDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::authorIcon, JsonpDeserializer.stringDeserializer(), "author_icon", new String[0]);
        op.add(Builder::authorLink, JsonpDeserializer.stringDeserializer(), "author_link", new String[0]);
        op.add(Builder::authorName, JsonpDeserializer.stringDeserializer(), "author_name", new String[0]);
        op.add(Builder::color, JsonpDeserializer.stringDeserializer(), "color", new String[0]);
        op.add(Builder::fallback, JsonpDeserializer.stringDeserializer(), "fallback", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(SlackAttachmentField._DESERIALIZER), "fields", new String[0]);
        op.add(Builder::footer, JsonpDeserializer.stringDeserializer(), "footer", new String[0]);
        op.add(Builder::footerIcon, JsonpDeserializer.stringDeserializer(), "footer_icon", new String[0]);
        op.add(Builder::imageUrl, JsonpDeserializer.stringDeserializer(), "image_url", new String[0]);
        op.add(Builder::pretext, JsonpDeserializer.stringDeserializer(), "pretext", new String[0]);
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text", new String[0]);
        op.add(Builder::thumbUrl, JsonpDeserializer.stringDeserializer(), "thumb_url", new String[0]);
        op.add(Builder::title, JsonpDeserializer.stringDeserializer(), "title", new String[0]);
        op.add(Builder::titleLink, JsonpDeserializer.stringDeserializer(), "title_link", new String[0]);
        op.add(Builder::ts, JsonpDeserializer.stringDeserializer(), "ts", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<SlackAttachment> {
        @Nullable
        private String authorIcon;
        @Nullable
        private String authorLink;
        private String authorName;
        @Nullable
        private String color;
        @Nullable
        private String fallback;
        @Nullable
        private List<SlackAttachmentField> fields;
        @Nullable
        private String footer;
        @Nullable
        private String footerIcon;
        @Nullable
        private String imageUrl;
        @Nullable
        private String pretext;
        @Nullable
        private String text;
        @Nullable
        private String thumbUrl;
        private String title;
        @Nullable
        private String titleLink;
        @Nullable
        private String ts;

        public Builder authorIcon(@Nullable String value) {
            this.authorIcon = value;
            return this;
        }

        public Builder authorLink(@Nullable String value) {
            this.authorLink = value;
            return this;
        }

        public Builder authorName(String value) {
            this.authorName = value;
            return this;
        }

        public Builder color(@Nullable String value) {
            this.color = value;
            return this;
        }

        public Builder fallback(@Nullable String value) {
            this.fallback = value;
            return this;
        }

        public Builder fields(@Nullable List<SlackAttachmentField> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(SlackAttachmentField ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(SlackAttachmentField value) {
            if (this.fields == null) {
                this.fields = new ArrayList<SlackAttachmentField>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder fields(Function<SlackAttachmentField.Builder, ObjectBuilder<SlackAttachmentField>> fn) {
            return this.fields(fn.apply(new SlackAttachmentField.Builder()).build());
        }

        public Builder addFields(Function<SlackAttachmentField.Builder, ObjectBuilder<SlackAttachmentField>> fn) {
            return this.addFields(fn.apply(new SlackAttachmentField.Builder()).build());
        }

        public Builder footer(@Nullable String value) {
            this.footer = value;
            return this;
        }

        public Builder footerIcon(@Nullable String value) {
            this.footerIcon = value;
            return this;
        }

        public Builder imageUrl(@Nullable String value) {
            this.imageUrl = value;
            return this;
        }

        public Builder pretext(@Nullable String value) {
            this.pretext = value;
            return this;
        }

        public Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        public Builder thumbUrl(@Nullable String value) {
            this.thumbUrl = value;
            return this;
        }

        public Builder title(String value) {
            this.title = value;
            return this;
        }

        public Builder titleLink(@Nullable String value) {
            this.titleLink = value;
            return this;
        }

        public Builder ts(@Nullable String value) {
            this.ts = value;
            return this;
        }

        @Override
        public SlackAttachment build() {
            return new SlackAttachment(this);
        }
    }
}

