/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.info;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class BuildInformation
implements JsonpSerializable {
    private final String date;
    private final String hash;
    public static final JsonpDeserializer<BuildInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BuildInformation::setupBuildInformationDeserializer, Builder::build);

    public BuildInformation(Builder builder) {
        this.date = Objects.requireNonNull(builder.date, "date");
        this.hash = Objects.requireNonNull(builder.hash, "hash");
    }

    public BuildInformation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String date() {
        return this.date;
    }

    public String hash() {
        return this.hash;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("date");
        generator.write(this.date);
        generator.writeKey("hash");
        generator.write(this.hash);
    }

    protected static void setupBuildInformationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::date, JsonpDeserializer.stringDeserializer(), "date", new String[0]);
        op.add(Builder::hash, JsonpDeserializer.stringDeserializer(), "hash", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<BuildInformation> {
        private String date;
        private String hash;

        public Builder date(String value) {
            this.date = value;
            return this;
        }

        public Builder hash(String value) {
            this.hash = value;
            return this;
        }

        @Override
        public BuildInformation build() {
            return new BuildInformation(this);
        }
    }
}

