/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.DataTierPhaseStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataTiers
extends Base {
    private final DataTierPhaseStatistics dataWarm;
    @Nullable
    private final DataTierPhaseStatistics dataFrozen;
    private final DataTierPhaseStatistics dataCold;
    private final DataTierPhaseStatistics dataContent;
    private final DataTierPhaseStatistics dataHot;
    public static final JsonpDeserializer<DataTiers> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataTiers::setupDataTiersDeserializer, Builder::build);

    public DataTiers(Builder builder) {
        super(builder);
        this.dataWarm = Objects.requireNonNull(builder.dataWarm, "data_warm");
        this.dataFrozen = builder.dataFrozen;
        this.dataCold = Objects.requireNonNull(builder.dataCold, "data_cold");
        this.dataContent = Objects.requireNonNull(builder.dataContent, "data_content");
        this.dataHot = Objects.requireNonNull(builder.dataHot, "data_hot");
    }

    public DataTiers(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public DataTierPhaseStatistics dataWarm() {
        return this.dataWarm;
    }

    @Nullable
    public DataTierPhaseStatistics dataFrozen() {
        return this.dataFrozen;
    }

    public DataTierPhaseStatistics dataCold() {
        return this.dataCold;
    }

    public DataTierPhaseStatistics dataContent() {
        return this.dataContent;
    }

    public DataTierPhaseStatistics dataHot() {
        return this.dataHot;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("data_warm");
        this.dataWarm.serialize(generator, mapper);
        if (this.dataFrozen != null) {
            generator.writeKey("data_frozen");
            this.dataFrozen.serialize(generator, mapper);
        }
        generator.writeKey("data_cold");
        this.dataCold.serialize(generator, mapper);
        generator.writeKey("data_content");
        this.dataContent.serialize(generator, mapper);
        generator.writeKey("data_hot");
        this.dataHot.serialize(generator, mapper);
    }

    protected static void setupDataTiersDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::dataWarm, DataTierPhaseStatistics._DESERIALIZER, "data_warm", new String[0]);
        op.add(Builder::dataFrozen, DataTierPhaseStatistics._DESERIALIZER, "data_frozen", new String[0]);
        op.add(Builder::dataCold, DataTierPhaseStatistics._DESERIALIZER, "data_cold", new String[0]);
        op.add(Builder::dataContent, DataTierPhaseStatistics._DESERIALIZER, "data_content", new String[0]);
        op.add(Builder::dataHot, DataTierPhaseStatistics._DESERIALIZER, "data_hot", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<DataTiers> {
        private DataTierPhaseStatistics dataWarm;
        @Nullable
        private DataTierPhaseStatistics dataFrozen;
        private DataTierPhaseStatistics dataCold;
        private DataTierPhaseStatistics dataContent;
        private DataTierPhaseStatistics dataHot;

        public Builder dataWarm(DataTierPhaseStatistics value) {
            this.dataWarm = value;
            return this;
        }

        public Builder dataWarm(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataWarm(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        public Builder dataFrozen(@Nullable DataTierPhaseStatistics value) {
            this.dataFrozen = value;
            return this;
        }

        public Builder dataFrozen(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataFrozen(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        public Builder dataCold(DataTierPhaseStatistics value) {
            this.dataCold = value;
            return this;
        }

        public Builder dataCold(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataCold(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        public Builder dataContent(DataTierPhaseStatistics value) {
            this.dataContent = value;
            return this;
        }

        public Builder dataContent(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataContent(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        public Builder dataHot(DataTierPhaseStatistics value) {
            this.dataHot = value;
            return this;
        }

        public Builder dataHot(Function<DataTierPhaseStatistics.Builder, ObjectBuilder<DataTierPhaseStatistics>> fn) {
            return this.dataHot(fn.apply(new DataTierPhaseStatistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataTiers build() {
            return new DataTiers(this);
        }
    }
}

