/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.ilm.Phases;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class IlmPolicyStatistics
implements JsonpSerializable {
    private final int indicesManaged;
    private final Phases phases;
    public static final JsonpDeserializer<IlmPolicyStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IlmPolicyStatistics::setupIlmPolicyStatisticsDeserializer, Builder::build);

    public IlmPolicyStatistics(Builder builder) {
        this.indicesManaged = Objects.requireNonNull(builder.indicesManaged, "indices_managed");
        this.phases = Objects.requireNonNull(builder.phases, "phases");
    }

    public IlmPolicyStatistics(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int indicesManaged() {
        return this.indicesManaged;
    }

    public Phases phases() {
        return this.phases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices_managed");
        generator.write(this.indicesManaged);
        generator.writeKey("phases");
        this.phases.serialize(generator, mapper);
    }

    protected static void setupIlmPolicyStatisticsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indicesManaged, JsonpDeserializer.integerDeserializer(), "indices_managed", new String[0]);
        op.add(Builder::phases, Phases._DESERIALIZER, "phases", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IlmPolicyStatistics> {
        private Integer indicesManaged;
        private Phases phases;

        public Builder indicesManaged(int value) {
            this.indicesManaged = value;
            return this;
        }

        public Builder phases(Phases value) {
            this.phases = value;
            return this;
        }

        public Builder phases(Function<Phases.Builder, ObjectBuilder<Phases>> fn) {
            return this.phases(fn.apply(new Phases.Builder()).build());
        }

        @Override
        public IlmPolicyStatistics build() {
            return new IlmPolicyStatistics(this);
        }
    }
}

