/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.InstanceDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.QuadConsumer;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;

public class ObjectDeserializer<ObjectType>
extends DelegatingDeserializer<ObjectType>
implements InstanceDeserializer<ObjectType, ObjectType> {
    private static final FieldDeserializer<Object> IGNORED_FIELD = new FieldDeserializer<Object>("-", null){

        @Override
        public void deserialize(JsonParser parser, JsonpMapper mapper, String fieldName, Object object) {
            JsonpUtils.skipValue(parser);
        }
    };
    private final Supplier<ObjectType> constructor;
    protected final Map<String, FieldDeserializer<?>> fieldDeserializers;
    private BiConsumer<ObjectType, String> keySetter;
    private String typeProperty;
    private QuadConsumer<ObjectType, String, JsonParser, JsonpMapper> unknownFieldHandler;

    public ObjectDeserializer(Supplier<ObjectType> constructor) {
        super(EnumSet.of(JsonParser.Event.START_OBJECT));
        this.constructor = constructor;
        this.fieldDeserializers = new HashMap();
    }

    @Override
    public ObjectType deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        return this.deserialize(this.constructor.get(), parser, mapper, event);
    }

    @Override
    public ObjectType deserialize(ObjectType value, JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        this.ensureAccepts(parser, event);
        if (event == JsonParser.Event.VALUE_NULL) {
            return null;
        }
        if (this.keySetter != null) {
            String key = JsonpUtils.expectKeyName(parser, parser.next());
            this.keySetter.accept(value, key);
            JsonpUtils.expectNextEvent(parser, JsonParser.Event.START_OBJECT);
        }
        if (this.typeProperty == null) {
            while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
                String fieldName = parser.getString();
                FieldDeserializer<?> fieldDeserializer = this.fieldDeserializers.get(fieldName);
                if (fieldDeserializer == null) {
                    this.parseUnknownField(parser, mapper, fieldName, value);
                    continue;
                }
                fieldDeserializer.deserialize(parser, mapper, fieldName, value);
            }
        } else {
            Map.Entry<String, JsonParser> unionInfo = JsonpUtils.lookAheadFieldValue(this.typeProperty, parser, mapper);
            String variant = unionInfo.getKey();
            JsonParser innerParser = unionInfo.getValue();
            FieldDeserializer<?> fieldDeserializer = this.fieldDeserializers.get(variant);
            if (fieldDeserializer == null) {
                this.parseUnknownField(parser, mapper, variant, value);
            } else {
                fieldDeserializer.deserialize(innerParser, mapper, variant, value);
            }
        }
        if (this.keySetter != null) {
            JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
        }
        return value;
    }

    protected void parseUnknownField(JsonParser parser, JsonpMapper mapper, String fieldName, ObjectType object) {
        if (this.unknownFieldHandler != null) {
            this.unknownFieldHandler.accept(object, fieldName, parser, mapper);
        } else if (mapper.ignoreUnknownFields()) {
            JsonpUtils.skipValue(parser);
        } else {
            throw new JsonParsingException("Unknown field [" + fieldName + "] for type [" + object.getClass().getName() + "]", parser.getLocation());
        }
    }

    @Override
    public void setUnknownFieldHandler(QuadConsumer<ObjectType, String, JsonParser, JsonpMapper> unknownFieldHandler) {
        this.unknownFieldHandler = unknownFieldHandler;
    }

    @Override
    public void ignore(String name) {
        this.fieldDeserializers.put(name, IGNORED_FIELD);
    }

    @Override
    public <FieldType> void add(BiConsumer<ObjectType, FieldType> setter, JsonpDeserializer<FieldType> deserializer, String name, String ... deprecatedNames) {
        FieldObjectDeserializer<ObjectType, FieldType> fieldDeserializer = new FieldObjectDeserializer<ObjectType, FieldType>(setter, deserializer, name, deprecatedNames);
        this.fieldDeserializers.put(name, fieldDeserializer);
        for (String alias : deprecatedNames) {
            this.fieldDeserializers.put(alias, fieldDeserializer);
        }
    }

    @Override
    public void setKey(BiConsumer<ObjectType, String> setter) {
        this.keySetter = setter;
    }

    @Override
    public void setTypeProperty(String name) {
        this.typeProperty = name;
    }

    public void add(ObjIntConsumer<ObjectType> setter, String name, String ... deprecatedNames) {
        this.add(setter::accept, ObjectDeserializer.integerDeserializer(), name, deprecatedNames);
    }

    public static abstract class FieldDeserializer<ObjectType> {
        protected final String name;
        protected final String[] deprecatedNames;

        public FieldDeserializer(String name, String[] deprecatedNames) {
            this.name = name;
            this.deprecatedNames = deprecatedNames;
        }

        public abstract void deserialize(JsonParser var1, JsonpMapper var2, String var3, ObjectType var4);
    }

    public static class FieldObjectDeserializer<ObjectType, FieldType>
    extends FieldDeserializer<ObjectType> {
        private final BiConsumer<ObjectType, FieldType> setter;
        private final JsonpDeserializer<FieldType> deserializer;

        public FieldObjectDeserializer(BiConsumer<ObjectType, FieldType> setter, JsonpDeserializer<FieldType> deserializer, String name, String[] deprecatedNames) {
            super(name, deprecatedNames);
            this.setter = setter;
            this.deserializer = deserializer;
        }

        public String name() {
            return this.name;
        }

        @Override
        public void deserialize(JsonParser parser, JsonpMapper mapper, String fieldName, ObjectType object) {
            FieldType fieldValue = this.deserializer.deserialize(parser, mapper);
            this.setter.accept(object, fieldValue);
        }
    }
}

