/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.Analyzer;
import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiTokenizationMode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KuromojiAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final KuromojiTokenizationMode mode;
    @Nullable
    private final String userDictionary;
    public static final JsonpDeserializer<KuromojiAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiAnalyzer::setupKuromojiAnalyzerDeserializer);

    private KuromojiAnalyzer(Builder builder) {
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.userDictionary = builder.userDictionary;
    }

    public static KuromojiAnalyzer of(Function<Builder, ObjectBuilder<KuromojiAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Kuromoji;
    }

    public final KuromojiTokenizationMode mode() {
        return this.mode;
    }

    @Nullable
    public final String userDictionary() {
        return this.userDictionary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji");
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        if (this.userDictionary != null) {
            generator.writeKey("user_dictionary");
            generator.write(this.userDictionary);
        }
    }

    protected static void setupKuromojiAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, KuromojiTokenizationMode._DESERIALIZER, "mode");
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary");
        op.ignore("type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<KuromojiAnalyzer> {
        private KuromojiTokenizationMode mode;
        @Nullable
        private String userDictionary;

        public final Builder mode(KuromojiTokenizationMode value) {
            this.mode = value;
            return this;
        }

        public final Builder userDictionary(@Nullable String value) {
            this.userDictionary = value;
            return this;
        }

        @Override
        public KuromojiAnalyzer build() {
            this._checkSingleUse();
            return new KuromojiAnalyzer(this);
        }
    }
}

