/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr.follow_info;

import co.elastic.clients.elasticsearch.ccr.follow_info.FollowerIndexParameters;
import co.elastic.clients.elasticsearch.ccr.follow_info.FollowerIndexStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FollowerIndex
implements JsonpSerializable {
    private final String followerIndex;
    private final String leaderIndex;
    @Nullable
    private final FollowerIndexParameters parameters;
    private final String remoteCluster;
    private final FollowerIndexStatus status;
    public static final JsonpDeserializer<FollowerIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FollowerIndex::setupFollowerIndexDeserializer);

    private FollowerIndex(Builder builder) {
        this.followerIndex = ApiTypeHelper.requireNonNull(builder.followerIndex, this, "followerIndex");
        this.leaderIndex = ApiTypeHelper.requireNonNull(builder.leaderIndex, this, "leaderIndex");
        this.parameters = builder.parameters;
        this.remoteCluster = ApiTypeHelper.requireNonNull(builder.remoteCluster, this, "remoteCluster");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
    }

    public static FollowerIndex of(Function<Builder, ObjectBuilder<FollowerIndex>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String followerIndex() {
        return this.followerIndex;
    }

    public final String leaderIndex() {
        return this.leaderIndex;
    }

    @Nullable
    public final FollowerIndexParameters parameters() {
        return this.parameters;
    }

    public final String remoteCluster() {
        return this.remoteCluster;
    }

    public final FollowerIndexStatus status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("follower_index");
        generator.write(this.followerIndex);
        generator.writeKey("leader_index");
        generator.write(this.leaderIndex);
        if (this.parameters != null) {
            generator.writeKey("parameters");
            this.parameters.serialize(generator, mapper);
        }
        generator.writeKey("remote_cluster");
        generator.write(this.remoteCluster);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
    }

    protected static void setupFollowerIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::followerIndex, JsonpDeserializer.stringDeserializer(), "follower_index");
        op.add(Builder::leaderIndex, JsonpDeserializer.stringDeserializer(), "leader_index");
        op.add(Builder::parameters, FollowerIndexParameters._DESERIALIZER, "parameters");
        op.add(Builder::remoteCluster, JsonpDeserializer.stringDeserializer(), "remote_cluster");
        op.add(Builder::status, FollowerIndexStatus._DESERIALIZER, "status");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FollowerIndex> {
        private String followerIndex;
        private String leaderIndex;
        @Nullable
        private FollowerIndexParameters parameters;
        private String remoteCluster;
        private FollowerIndexStatus status;

        public final Builder followerIndex(String value) {
            this.followerIndex = value;
            return this;
        }

        public final Builder leaderIndex(String value) {
            this.leaderIndex = value;
            return this;
        }

        public final Builder parameters(@Nullable FollowerIndexParameters value) {
            this.parameters = value;
            return this;
        }

        public final Builder parameters(Function<FollowerIndexParameters.Builder, ObjectBuilder<FollowerIndexParameters>> fn) {
            return this.parameters(fn.apply(new FollowerIndexParameters.Builder()).build());
        }

        public final Builder remoteCluster(String value) {
            this.remoteCluster = value;
            return this;
        }

        public final Builder status(FollowerIndexStatus value) {
            this.status = value;
            return this;
        }

        @Override
        public FollowerIndex build() {
            this._checkSingleUse();
            return new FollowerIndex(this);
        }
    }
}

