/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluation;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationOutlierDetectionMetrics;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeEvaluationOutlierDetection
implements DataframeEvaluationVariant,
JsonpSerializable {
    private final String actualField;
    private final String predictedProbabilityField;
    @Nullable
    private final DataframeEvaluationOutlierDetectionMetrics metrics;
    public static final JsonpDeserializer<DataframeEvaluationOutlierDetection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeEvaluationOutlierDetection::setupDataframeEvaluationOutlierDetectionDeserializer);

    private DataframeEvaluationOutlierDetection(Builder builder) {
        this.actualField = ApiTypeHelper.requireNonNull(builder.actualField, this, "actualField");
        this.predictedProbabilityField = ApiTypeHelper.requireNonNull(builder.predictedProbabilityField, this, "predictedProbabilityField");
        this.metrics = builder.metrics;
    }

    public static DataframeEvaluationOutlierDetection of(Function<Builder, ObjectBuilder<DataframeEvaluationOutlierDetection>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public DataframeEvaluation.Kind _dataframeEvaluationKind() {
        return DataframeEvaluation.Kind.OutlierDetection;
    }

    public final String actualField() {
        return this.actualField;
    }

    public final String predictedProbabilityField() {
        return this.predictedProbabilityField;
    }

    @Nullable
    public final DataframeEvaluationOutlierDetectionMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actual_field");
        generator.write(this.actualField);
        generator.writeKey("predicted_probability_field");
        generator.write(this.predictedProbabilityField);
        if (this.metrics != null) {
            generator.writeKey("metrics");
            this.metrics.serialize(generator, mapper);
        }
    }

    protected static void setupDataframeEvaluationOutlierDetectionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actualField, JsonpDeserializer.stringDeserializer(), "actual_field");
        op.add(Builder::predictedProbabilityField, JsonpDeserializer.stringDeserializer(), "predicted_probability_field");
        op.add(Builder::metrics, DataframeEvaluationOutlierDetectionMetrics._DESERIALIZER, "metrics");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataframeEvaluationOutlierDetection> {
        private String actualField;
        private String predictedProbabilityField;
        @Nullable
        private DataframeEvaluationOutlierDetectionMetrics metrics;

        public final Builder actualField(String value) {
            this.actualField = value;
            return this;
        }

        public final Builder predictedProbabilityField(String value) {
            this.predictedProbabilityField = value;
            return this;
        }

        public final Builder metrics(@Nullable DataframeEvaluationOutlierDetectionMetrics value) {
            this.metrics = value;
            return this;
        }

        public final Builder metrics(Function<DataframeEvaluationOutlierDetectionMetrics.Builder, ObjectBuilder<DataframeEvaluationOutlierDetectionMetrics>> fn) {
            return this.metrics(fn.apply(new DataframeEvaluationOutlierDetectionMetrics.Builder()).build());
        }

        @Override
        public DataframeEvaluationOutlierDetection build() {
            this._checkSingleUse();
            return new DataframeEvaluationOutlierDetection(this);
        }
    }
}

