/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.ConfusionMatrixItem;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeClassificationSummaryMulticlassConfusionMatrix
implements JsonpSerializable {
    private final List<ConfusionMatrixItem> confusionMatrix;
    private final int otherActualClassCount;
    public static final JsonpDeserializer<DataframeClassificationSummaryMulticlassConfusionMatrix> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeClassificationSummaryMulticlassConfusionMatrix::setupDataframeClassificationSummaryMulticlassConfusionMatrixDeserializer);

    private DataframeClassificationSummaryMulticlassConfusionMatrix(Builder builder) {
        this.confusionMatrix = ApiTypeHelper.unmodifiableRequired(builder.confusionMatrix, (Object)this, "confusionMatrix");
        this.otherActualClassCount = ApiTypeHelper.requireNonNull(builder.otherActualClassCount, this, "otherActualClassCount");
    }

    public static DataframeClassificationSummaryMulticlassConfusionMatrix of(Function<Builder, ObjectBuilder<DataframeClassificationSummaryMulticlassConfusionMatrix>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ConfusionMatrixItem> confusionMatrix() {
        return this.confusionMatrix;
    }

    public final int otherActualClassCount() {
        return this.otherActualClassCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.confusionMatrix)) {
            generator.writeKey("confusion_matrix");
            generator.writeStartArray();
            for (ConfusionMatrixItem item0 : this.confusionMatrix) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("other_actual_class_count");
        generator.write(this.otherActualClassCount);
    }

    protected static void setupDataframeClassificationSummaryMulticlassConfusionMatrixDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::confusionMatrix, JsonpDeserializer.arrayDeserializer(ConfusionMatrixItem._DESERIALIZER), "confusion_matrix");
        op.add(Builder::otherActualClassCount, JsonpDeserializer.integerDeserializer(), "other_actual_class_count");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataframeClassificationSummaryMulticlassConfusionMatrix> {
        private List<ConfusionMatrixItem> confusionMatrix;
        private Integer otherActualClassCount;

        public final Builder confusionMatrix(List<ConfusionMatrixItem> list) {
            this.confusionMatrix = Builder._listAddAll(this.confusionMatrix, list);
            return this;
        }

        public final Builder confusionMatrix(ConfusionMatrixItem value, ConfusionMatrixItem ... values) {
            this.confusionMatrix = Builder._listAdd(this.confusionMatrix, value, values);
            return this;
        }

        public final Builder confusionMatrix(Function<ConfusionMatrixItem.Builder, ObjectBuilder<ConfusionMatrixItem>> fn) {
            return this.confusionMatrix(fn.apply(new ConfusionMatrixItem.Builder()).build(), new ConfusionMatrixItem[0]);
        }

        public final Builder otherActualClassCount(int value) {
            this.otherActualClassCount = value;
            return this;
        }

        @Override
        public DataframeClassificationSummaryMulticlassConfusionMatrix build() {
            this._checkSingleUse();
            return new DataframeClassificationSummaryMulticlassConfusionMatrix(this);
        }
    }
}

