/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.async_search.AsyncSearchResponseBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AsyncSearchStatusResponse<TDocument>
extends AsyncSearchResponseBase {
    private final ShardStatistics shards;
    private final int completionStatus;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<AsyncSearchStatusResponse<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> AsyncSearchStatusResponse.createAsyncSearchStatusResponseDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:async_search.status.TDocument")));

    private AsyncSearchStatusResponse(Builder<TDocument> builder) {
        super(builder);
        this.shards = ApiTypeHelper.requireNonNull(((Builder)builder).shards, this, "shards");
        this.completionStatus = ApiTypeHelper.requireNonNull(((Builder)builder).completionStatus, this, "completionStatus");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> AsyncSearchStatusResponse<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<AsyncSearchStatusResponse<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final int completionStatus() {
        return this.completionStatus;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("completion_status");
        generator.write(this.completionStatus);
    }

    public static <TDocument> JsonpDeserializer<AsyncSearchStatusResponse<TDocument>> createAsyncSearchStatusResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> AsyncSearchStatusResponse.setupAsyncSearchStatusResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupAsyncSearchStatusResponseDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        AsyncSearchResponseBase.setupAsyncSearchResponseBaseDeserializer(op);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::completionStatus, JsonpDeserializer.integerDeserializer(), "completion_status");
    }

    public static class Builder<TDocument>
    extends AsyncSearchResponseBase.AbstractBuilder<Builder<TDocument>>
    implements ObjectBuilder<AsyncSearchStatusResponse<TDocument>> {
        private ShardStatistics shards;
        private Integer completionStatus;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder<TDocument> completionStatus(int value) {
            this.completionStatus = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public AsyncSearchStatusResponse<TDocument> build() {
            this._checkSingleUse();
            return new AsyncSearchStatusResponse(this);
        }
    }
}

