/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ValidationLoss
implements JsonpSerializable {
    private final List<String> foldValues;
    private final String lossType;
    public static final JsonpDeserializer<ValidationLoss> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ValidationLoss::setupValidationLossDeserializer);

    private ValidationLoss(Builder builder) {
        this.foldValues = ApiTypeHelper.unmodifiableRequired(builder.foldValues, (Object)this, "foldValues");
        this.lossType = ApiTypeHelper.requireNonNull(builder.lossType, this, "lossType");
    }

    public static ValidationLoss of(Function<Builder, ObjectBuilder<ValidationLoss>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> foldValues() {
        return this.foldValues;
    }

    public final String lossType() {
        return this.lossType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.foldValues)) {
            generator.writeKey("fold_values");
            generator.writeStartArray();
            for (String item0 : this.foldValues) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("loss_type");
        generator.write(this.lossType);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupValidationLossDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::foldValues, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fold_values");
        op.add(Builder::lossType, JsonpDeserializer.stringDeserializer(), "loss_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ValidationLoss> {
        private List<String> foldValues;
        private String lossType;

        public final Builder foldValues(List<String> list) {
            this.foldValues = Builder._listAddAll(this.foldValues, list);
            return this;
        }

        public final Builder foldValues(String value, String ... values) {
            this.foldValues = Builder._listAdd(this.foldValues, value, values);
            return this;
        }

        public final Builder lossType(String value) {
            this.lossType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ValidationLoss build() {
            this._checkSingleUse();
            return new ValidationLoss(this);
        }
    }
}

