/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.SpanQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.SpanQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;

@JsonpDeserializable
public class SpanGapQuery
implements SpanQueryVariant,
JsonpSerializable {
    private final String field;
    private final int spanWidth;
    public static final JsonpDeserializer<SpanGapQuery> _DESERIALIZER = JsonpDeserializer.of(EnumSet.of(JsonParser.Event.START_OBJECT), (parser, mapper, event) -> {
        String name = JsonpUtils.expectKeyName(parser, parser.next());
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.VALUE_NUMBER);
        int spanWidth = parser.getInt();
        JsonpUtils.expectNextEvent(parser, JsonParser.Event.END_OBJECT);
        return new Builder().field(name).spanWidth(spanWidth).build();
    });

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanGap;
    }

    private SpanGapQuery(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.spanWidth = Objects.requireNonNull(builder.spanWidth, "span_width");
    }

    public static SpanGapQuery of(Consumer<Builder> fn) {
        Builder builder = new Builder();
        fn.accept(builder);
        return builder.build();
    }

    public final String field() {
        return this.field;
    }

    public final int spanWidth() {
        return this.spanWidth;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.write(this.field, this.spanWidth);
        generator.writeEnd();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SpanGapQuery> {
        private String field;
        private Integer spanWidth;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder spanWidth(int value) {
            this.spanWidth = value;
            return this;
        }

        @Override
        public SpanGapQuery build() {
            this._checkSingleUse();
            return new SpanGapQuery(this);
        }
    }
}

