/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.RequestOptions;

public class SafeResponseConsumer<T>
implements HttpAsyncResponseConsumer<T> {
    private final HttpAsyncResponseConsumer<T> delegate;
    public static final HttpAsyncResponseConsumerFactory DEFAULT_FACTORY = () -> new SafeResponseConsumer(RequestOptions.DEFAULT.getHttpAsyncResponseConsumerFactory().createHttpAsyncResponseConsumer());
    public static final RequestOptions DEFAULT_REQUEST_OPTIONS;

    public SafeResponseConsumer(HttpAsyncResponseConsumer<T> delegate) {
        this.delegate = delegate;
    }

    private static <T extends Throwable> void throwUnchecked(Throwable thr) throws T {
        throw thr;
    }

    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        try {
            this.delegate.responseReceived(response);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error receiving response", e);
        }
    }

    public void consumeContent(ContentDecoder decoder, IOControl ioControl) throws IOException {
        try {
            this.delegate.consumeContent(decoder, ioControl);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error consuming content", e);
        }
    }

    public void responseCompleted(HttpContext context) {
        try {
            this.delegate.responseCompleted(context);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error completing response", e);
        }
    }

    public void failed(Exception ex) {
        try {
            this.delegate.failed(ex);
        }
        catch (Exception e) {
            SafeResponseConsumer.throwUnchecked(e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error handling failure", e);
        }
    }

    public Exception getException() {
        return this.delegate.getException();
    }

    public T getResult() {
        return (T)this.delegate.getResult();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean cancel() {
        return this.delegate.cancel();
    }

    static {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setHttpAsyncResponseConsumerFactory(DEFAULT_FACTORY);
        DEFAULT_REQUEST_OPTIONS = builder.build();
    }
}

