/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldAndFormat
implements JsonpSerializable {
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final Boolean includeUnmapped;
    public static final JsonpDeserializer<FieldAndFormat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldAndFormat::setupFieldAndFormatDeserializer);

    private FieldAndFormat(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.format = builder.format;
        this.includeUnmapped = builder.includeUnmapped;
    }

    public static FieldAndFormat of(Function<Builder, ObjectBuilder<FieldAndFormat>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Boolean includeUnmapped() {
        return this.includeUnmapped;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.includeUnmapped != null) {
            generator.writeKey("include_unmapped");
            generator.write(this.includeUnmapped.booleanValue());
        }
    }

    protected static void setupFieldAndFormatDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::includeUnmapped, JsonpDeserializer.booleanDeserializer(), "include_unmapped");
        op.shortcutProperty("field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldAndFormat> {
        private String field;
        @Nullable
        private String format;
        @Nullable
        private Boolean includeUnmapped;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder includeUnmapped(@Nullable Boolean value) {
            this.includeUnmapped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldAndFormat build() {
            this._checkSingleUse();
            return new FieldAndFormat(this);
        }
    }
}

