/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalMetricDetail;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class RankEvalResponse
implements JsonpSerializable {
    private final double metricScore;
    private final Map<String, RankEvalMetricDetail> details;
    private final Map<String, JsonData> failures;
    public static final JsonpDeserializer<RankEvalResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalResponse::setupRankEvalResponseDeserializer);

    private RankEvalResponse(Builder builder) {
        this.metricScore = ApiTypeHelper.requireNonNull(builder.metricScore, this, "metricScore");
        this.details = ApiTypeHelper.unmodifiableRequired(builder.details, (Object)this, "details");
        this.failures = ApiTypeHelper.unmodifiableRequired(builder.failures, (Object)this, "failures");
    }

    public static RankEvalResponse of(Function<Builder, ObjectBuilder<RankEvalResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double metricScore() {
        return this.metricScore;
    }

    public final Map<String, RankEvalMetricDetail> details() {
        return this.details;
    }

    public final Map<String, JsonData> failures() {
        return this.failures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("metric_score");
        generator.write(this.metricScore);
        if (ApiTypeHelper.isDefined(this.details)) {
            generator.writeKey("details");
            generator.writeStartObject();
            for (Map.Entry<String, RankEvalMetricDetail> entry : this.details.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.failures.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRankEvalResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::metricScore, JsonpDeserializer.doubleDeserializer(), "metric_score");
        op.add(Builder::details, JsonpDeserializer.stringMapDeserializer(RankEvalMetricDetail._DESERIALIZER), "details");
        op.add(Builder::failures, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "failures");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RankEvalResponse> {
        private Double metricScore;
        private Map<String, RankEvalMetricDetail> details;
        private Map<String, JsonData> failures;

        public final Builder metricScore(double value) {
            this.metricScore = value;
            return this;
        }

        public final Builder details(Map<String, RankEvalMetricDetail> map) {
            this.details = Builder._mapPutAll(this.details, map);
            return this;
        }

        public final Builder details(String key, RankEvalMetricDetail value) {
            this.details = Builder._mapPut(this.details, key, value);
            return this;
        }

        public final Builder details(String key, Function<RankEvalMetricDetail.Builder, ObjectBuilder<RankEvalMetricDetail>> fn) {
            return this.details(key, fn.apply(new RankEvalMetricDetail.Builder()).build());
        }

        public final Builder failures(Map<String, JsonData> map) {
            this.failures = Builder._mapPutAll(this.failures, map);
            return this;
        }

        public final Builder failures(String key, JsonData value) {
            this.failures = Builder._mapPut(this.failures, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RankEvalResponse build() {
            this._checkSingleUse();
            return new RankEvalResponse(this);
        }
    }
}

