/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Job;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetJobsResponse
implements JsonpSerializable {
    private final long count;
    private final List<Job> jobs;
    public static final JsonpDeserializer<GetJobsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetJobsResponse::setupGetJobsResponseDeserializer);

    private GetJobsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.jobs = ApiTypeHelper.unmodifiableRequired(builder.jobs, (Object)this, "jobs");
    }

    public static GetJobsResponse of(Function<Builder, ObjectBuilder<GetJobsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<Job> jobs() {
        return this.jobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.jobs)) {
            generator.writeKey("jobs");
            generator.writeStartArray();
            for (Job item0 : this.jobs) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetJobsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::jobs, JsonpDeserializer.arrayDeserializer(Job._DESERIALIZER), "jobs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetJobsResponse> {
        private Long count;
        private List<Job> jobs;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder jobs(List<Job> list) {
            this.jobs = Builder._listAddAll(this.jobs, list);
            return this;
        }

        public final Builder jobs(Job value, Job ... values) {
            this.jobs = Builder._listAdd(this.jobs, value, values);
            return this;
        }

        public final Builder jobs(Function<Job.Builder, ObjectBuilder<Job>> fn) {
            return this.jobs(fn.apply(new Job.Builder()).build(), new Job[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetJobsResponse build() {
            this._checkSingleUse();
            return new GetJobsResponse(this);
        }
    }
}

