/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.eql.EqlGetResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class EqlGetRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final Time keepAlive;
    @Nullable
    private final Time waitForCompletionTimeout;
    public static final SimpleEndpoint<EqlGetRequest, ?> _ENDPOINT = new SimpleEndpoint<EqlGetRequest, EqlGetResponse<Object>>("es/eql.get", request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_eql");
            buf.append("/search");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.keepAlive != null) {
            params.put("keep_alive", request.keepAlive._toJsonString());
        }
        if (request.waitForCompletionTimeout != null) {
            params.put("wait_for_completion_timeout", request.waitForCompletionTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, EqlGetResponse._DESERIALIZER);

    private EqlGetRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.keepAlive = builder.keepAlive;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    public static EqlGetRequest of(Function<Builder, ObjectBuilder<EqlGetRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time keepAlive() {
        return this.keepAlive;
    }

    @Nullable
    public final Time waitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public static <TEvent> Endpoint<EqlGetRequest, EqlGetResponse<TEvent>, ErrorResponse> createGetEndpoint(JsonpDeserializer<TEvent> tEventDeserializer) {
        return _ENDPOINT.withResponseDeserializer(EqlGetResponse.createEqlGetResponseDeserializer(tEventDeserializer));
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<EqlGetRequest> {
        private String id;
        @Nullable
        private Time keepAlive;
        @Nullable
        private Time waitForCompletionTimeout;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder keepAlive(@Nullable Time value) {
            this.keepAlive = value;
            return this;
        }

        public final Builder keepAlive(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.keepAlive(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitForCompletionTimeout(@Nullable Time value) {
            this.waitForCompletionTimeout = value;
            return this;
        }

        public final Builder waitForCompletionTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.waitForCompletionTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public EqlGetRequest build() {
            this._checkSingleUse();
            return new EqlGetRequest(this);
        }
    }
}

