/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Retention
implements JsonpSerializable {
    private final Time expireAfter;
    private final int maxCount;
    private final int minCount;
    public static final JsonpDeserializer<Retention> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Retention::setupRetentionDeserializer);

    private Retention(Builder builder) {
        this.expireAfter = ApiTypeHelper.requireNonNull(builder.expireAfter, this, "expireAfter");
        this.maxCount = ApiTypeHelper.requireNonNull(builder.maxCount, this, "maxCount");
        this.minCount = ApiTypeHelper.requireNonNull(builder.minCount, this, "minCount");
    }

    public static Retention of(Function<Builder, ObjectBuilder<Retention>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Time expireAfter() {
        return this.expireAfter;
    }

    public final int maxCount() {
        return this.maxCount;
    }

    public final int minCount() {
        return this.minCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expire_after");
        this.expireAfter.serialize(generator, mapper);
        generator.writeKey("max_count");
        generator.write(this.maxCount);
        generator.writeKey("min_count");
        generator.write(this.minCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRetentionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::expireAfter, Time._DESERIALIZER, "expire_after");
        op.add(Builder::maxCount, JsonpDeserializer.integerDeserializer(), "max_count");
        op.add(Builder::minCount, JsonpDeserializer.integerDeserializer(), "min_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Retention> {
        private Time expireAfter;
        private Integer maxCount;
        private Integer minCount;

        public final Builder expireAfter(Time value) {
            this.expireAfter = value;
            return this;
        }

        public final Builder expireAfter(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.expireAfter(fn.apply(new Time.Builder()).build());
        }

        public final Builder maxCount(int value) {
            this.maxCount = value;
            return this;
        }

        public final Builder minCount(int value) {
            this.minCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Retention build() {
            this._checkSingleUse();
            return new Retention(this);
        }
    }
}

