/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.logstash;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.logstash.Pipeline;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.BooleanEndpoint;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class PutPipelineRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    private final Pipeline pipeline;
    public static final JsonpDeserializer<PutPipelineRequest> _DESERIALIZER = PutPipelineRequest.createPutPipelineRequestDeserializer();
    public static final Endpoint<PutPipelineRequest, BooleanResponse, ErrorResponse> _ENDPOINT = new BooleanEndpoint<PutPipelineRequest>("es/logstash.put_pipeline", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_logstash");
            buf.append("/pipeline");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, (Function<PutPipelineRequest, Map<String, String>>)((Function<PutPipelineRequest, Map>)request -> Collections.emptyMap()), (Function<PutPipelineRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), true, null);

    private PutPipelineRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.pipeline = ApiTypeHelper.requireNonNull(builder.pipeline, this, "pipeline");
    }

    public static PutPipelineRequest of(Function<Builder, ObjectBuilder<PutPipelineRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final Pipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.pipeline.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutPipelineRequest> createPutPipelineRequestDeserializer() {
        JsonpDeserializer<Pipeline> valueDeserializer = Pipeline._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().pipeline((Pipeline)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PutPipelineRequest> {
        private String id;
        private Pipeline pipeline;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder pipeline(Pipeline value) {
            this.pipeline = value;
            return this;
        }

        public final Builder pipeline(Function<Pipeline.Builder, ObjectBuilder<Pipeline>> fn) {
            return this.pipeline(fn.apply(new Pipeline.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            Pipeline value = Pipeline._DESERIALIZER.deserialize(parser, mapper);
            return this.pipeline(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutPipelineRequest build() {
            this._checkSingleUse();
            return new PutPipelineRequest(this);
        }
    }
}

