/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.FlushJobResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FlushJobRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final DateTime advanceTime;
    @Nullable
    private final Boolean calcInterim;
    @Nullable
    private final DateTime end;
    private final String jobId;
    @Nullable
    private final DateTime skipTime;
    @Nullable
    private final DateTime start;
    public static final JsonpDeserializer<FlushJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FlushJobRequest::setupFlushJobRequestDeserializer);
    public static final Endpoint<FlushJobRequest, FlushJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<FlushJobRequest, FlushJobResponse>("es/ml.flush_job", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_flush");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, FlushJobResponse._DESERIALIZER);

    private FlushJobRequest(Builder builder) {
        this.advanceTime = builder.advanceTime;
        this.calcInterim = builder.calcInterim;
        this.end = builder.end;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.skipTime = builder.skipTime;
        this.start = builder.start;
    }

    public static FlushJobRequest of(Function<Builder, ObjectBuilder<FlushJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime advanceTime() {
        return this.advanceTime;
    }

    @Nullable
    public final Boolean calcInterim() {
        return this.calcInterim;
    }

    @Nullable
    public final DateTime end() {
        return this.end;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final DateTime skipTime() {
        return this.skipTime;
    }

    @Nullable
    public final DateTime start() {
        return this.start;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.advanceTime != null) {
            generator.writeKey("advance_time");
            this.advanceTime.serialize(generator, mapper);
        }
        if (this.calcInterim != null) {
            generator.writeKey("calc_interim");
            generator.write(this.calcInterim.booleanValue());
        }
        if (this.end != null) {
            generator.writeKey("end");
            this.end.serialize(generator, mapper);
        }
        if (this.skipTime != null) {
            generator.writeKey("skip_time");
            this.skipTime.serialize(generator, mapper);
        }
        if (this.start != null) {
            generator.writeKey("start");
            this.start.serialize(generator, mapper);
        }
    }

    protected static void setupFlushJobRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::advanceTime, DateTime._DESERIALIZER, "advance_time");
        op.add(Builder::calcInterim, JsonpDeserializer.booleanDeserializer(), "calc_interim");
        op.add(Builder::end, DateTime._DESERIALIZER, "end");
        op.add(Builder::skipTime, DateTime._DESERIALIZER, "skip_time");
        op.add(Builder::start, DateTime._DESERIALIZER, "start");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FlushJobRequest> {
        @Nullable
        private DateTime advanceTime;
        @Nullable
        private Boolean calcInterim;
        @Nullable
        private DateTime end;
        private String jobId;
        @Nullable
        private DateTime skipTime;
        @Nullable
        private DateTime start;

        public final Builder advanceTime(@Nullable DateTime value) {
            this.advanceTime = value;
            return this;
        }

        public final Builder calcInterim(@Nullable Boolean value) {
            this.calcInterim = value;
            return this;
        }

        public final Builder end(@Nullable DateTime value) {
            this.end = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder skipTime(@Nullable DateTime value) {
            this.skipTime = value;
            return this;
        }

        public final Builder start(@Nullable DateTime value) {
            this.start = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FlushJobRequest build() {
            this._checkSingleUse();
            return new FlushJobRequest(this);
        }
    }
}

