/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_rollup_caps;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class RollupCapabilitySummary
implements JsonpSerializable {
    private final Map<String, Map<String, JsonData>> fields;
    private final String indexPattern;
    private final String jobId;
    private final String rollupIndex;
    public static final JsonpDeserializer<RollupCapabilitySummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupCapabilitySummary::setupRollupCapabilitySummaryDeserializer);

    private RollupCapabilitySummary(Builder builder) {
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.indexPattern = ApiTypeHelper.requireNonNull(builder.indexPattern, this, "indexPattern");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.rollupIndex = ApiTypeHelper.requireNonNull(builder.rollupIndex, this, "rollupIndex");
    }

    public static RollupCapabilitySummary of(Function<Builder, ObjectBuilder<RollupCapabilitySummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Map<String, JsonData>> fields() {
        return this.fields;
    }

    public final String indexPattern() {
        return this.indexPattern;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String rollupIndex() {
        return this.rollupIndex;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Map<String, JsonData>> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartObject();
                if (item0.getValue() != null) {
                    for (Map.Entry<String, JsonData> item1 : item0.getValue().entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("index_pattern");
        generator.write(this.indexPattern);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("rollup_index");
        generator.write(this.rollupIndex);
    }

    protected static void setupRollupCapabilitySummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "fields");
        op.add(Builder::indexPattern, JsonpDeserializer.stringDeserializer(), "index_pattern");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::rollupIndex, JsonpDeserializer.stringDeserializer(), "rollup_index");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RollupCapabilitySummary> {
        private Map<String, Map<String, JsonData>> fields;
        private String indexPattern;
        private String jobId;
        private String rollupIndex;

        public final Builder fields(Map<String, Map<String, JsonData>> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, Map<String, JsonData> value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder indexPattern(String value) {
            this.indexPattern = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder rollupIndex(String value) {
            this.rollupIndex = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RollupCapabilitySummary build() {
            this._checkSingleUse();
            return new RollupCapabilitySummary(this);
        }
    }
}

