/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoPointProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean ignoreZValue;
    @Nullable
    private final GeoLocation nullValue;
    public static final JsonpDeserializer<GeoPointProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoPointProperty::setupGeoPointPropertyDeserializer);

    private GeoPointProperty(Builder builder) {
        super(builder);
        this.ignoreMalformed = builder.ignoreMalformed;
        this.ignoreZValue = builder.ignoreZValue;
        this.nullValue = builder.nullValue;
    }

    public static GeoPointProperty of(Function<Builder, ObjectBuilder<GeoPointProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.GeoPoint;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final Boolean ignoreZValue() {
        return this.ignoreZValue;
    }

    @Nullable
    public final GeoLocation nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "geo_point");
        super.serializeInternal(generator, mapper);
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.ignoreZValue != null) {
            generator.writeKey("ignore_z_value");
            generator.write(this.ignoreZValue.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            this.nullValue.serialize(generator, mapper);
        }
    }

    protected static void setupGeoPointPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::ignoreZValue, JsonpDeserializer.booleanDeserializer(), "ignore_z_value");
        op.add(Builder::nullValue, GeoLocation._DESERIALIZER, "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoPointProperty> {
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean ignoreZValue;
        @Nullable
        private GeoLocation nullValue;

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder ignoreZValue(@Nullable Boolean value) {
            this.ignoreZValue = value;
            return this;
        }

        public final Builder nullValue(@Nullable GeoLocation value) {
            this.nullValue = value;
            return this;
        }

        public final Builder nullValue(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.nullValue(fn.apply(new GeoLocation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoPointProperty build() {
            this._checkSingleUse();
            return new GeoPointProperty(this);
        }
    }
}

