/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TrainingPriority;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelAssignmentTaskParameters
implements JsonpSerializable {
    private final int modelBytes;
    private final String modelId;
    private final String deploymentId;
    private final String cacheSize;
    private final int numberOfAllocations;
    private final TrainingPriority priority;
    private final int queueCapacity;
    private final int threadsPerAllocation;
    public static final JsonpDeserializer<TrainedModelAssignmentTaskParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelAssignmentTaskParameters::setupTrainedModelAssignmentTaskParametersDeserializer);

    private TrainedModelAssignmentTaskParameters(Builder builder) {
        this.modelBytes = ApiTypeHelper.requireNonNull(builder.modelBytes, this, "modelBytes");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.deploymentId = ApiTypeHelper.requireNonNull(builder.deploymentId, this, "deploymentId");
        this.cacheSize = ApiTypeHelper.requireNonNull(builder.cacheSize, this, "cacheSize");
        this.numberOfAllocations = ApiTypeHelper.requireNonNull(builder.numberOfAllocations, this, "numberOfAllocations");
        this.priority = ApiTypeHelper.requireNonNull(builder.priority, this, "priority");
        this.queueCapacity = ApiTypeHelper.requireNonNull(builder.queueCapacity, this, "queueCapacity");
        this.threadsPerAllocation = ApiTypeHelper.requireNonNull(builder.threadsPerAllocation, this, "threadsPerAllocation");
    }

    public static TrainedModelAssignmentTaskParameters of(Function<Builder, ObjectBuilder<TrainedModelAssignmentTaskParameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int modelBytes() {
        return this.modelBytes;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String cacheSize() {
        return this.cacheSize;
    }

    public final int numberOfAllocations() {
        return this.numberOfAllocations;
    }

    public final TrainingPriority priority() {
        return this.priority;
    }

    public final int queueCapacity() {
        return this.queueCapacity;
    }

    public final int threadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_bytes");
        generator.write(this.modelBytes);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("deployment_id");
        generator.write(this.deploymentId);
        generator.writeKey("cache_size");
        generator.write(this.cacheSize);
        generator.writeKey("number_of_allocations");
        generator.write(this.numberOfAllocations);
        generator.writeKey("priority");
        this.priority.serialize(generator, mapper);
        generator.writeKey("queue_capacity");
        generator.write(this.queueCapacity);
        generator.writeKey("threads_per_allocation");
        generator.write(this.threadsPerAllocation);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelAssignmentTaskParametersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelBytes, JsonpDeserializer.integerDeserializer(), "model_bytes");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::deploymentId, JsonpDeserializer.stringDeserializer(), "deployment_id");
        op.add(Builder::cacheSize, JsonpDeserializer.stringDeserializer(), "cache_size");
        op.add(Builder::numberOfAllocations, JsonpDeserializer.integerDeserializer(), "number_of_allocations");
        op.add(Builder::priority, TrainingPriority._DESERIALIZER, "priority");
        op.add(Builder::queueCapacity, JsonpDeserializer.integerDeserializer(), "queue_capacity");
        op.add(Builder::threadsPerAllocation, JsonpDeserializer.integerDeserializer(), "threads_per_allocation");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelAssignmentTaskParameters> {
        private Integer modelBytes;
        private String modelId;
        private String deploymentId;
        private String cacheSize;
        private Integer numberOfAllocations;
        private TrainingPriority priority;
        private Integer queueCapacity;
        private Integer threadsPerAllocation;

        public final Builder modelBytes(int value) {
            this.modelBytes = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder deploymentId(String value) {
            this.deploymentId = value;
            return this;
        }

        public final Builder cacheSize(String value) {
            this.cacheSize = value;
            return this;
        }

        public final Builder numberOfAllocations(int value) {
            this.numberOfAllocations = value;
            return this;
        }

        public final Builder priority(TrainingPriority value) {
            this.priority = value;
            return this;
        }

        public final Builder queueCapacity(int value) {
            this.queueCapacity = value;
            return this;
        }

        public final Builder threadsPerAllocation(int value) {
            this.threadsPerAllocation = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelAssignmentTaskParameters build() {
            this._checkSingleUse();
            return new TrainedModelAssignmentTaskParameters(this);
        }
    }
}

