/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch.inference.DeleteModelRequest;
import co.elastic.clients.elasticsearch.inference.DeleteModelResponse;
import co.elastic.clients.elasticsearch.inference.GetModelRequest;
import co.elastic.clients.elasticsearch.inference.GetModelResponse;
import co.elastic.clients.elasticsearch.inference.InferenceRequest;
import co.elastic.clients.elasticsearch.inference.InferenceResponse;
import co.elastic.clients.elasticsearch.inference.PutModelRequest;
import co.elastic.clients.elasticsearch.inference.PutModelResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchInferenceAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchInferenceAsyncClient> {
    public ElasticsearchInferenceAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchInferenceAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchInferenceAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchInferenceAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteModelRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteModelResponse> deleteModel(Function<DeleteModelRequest.Builder, ObjectBuilder<DeleteModelRequest>> fn) {
        return this.deleteModel(fn.apply(new DeleteModelRequest.Builder()).build());
    }

    public CompletableFuture<GetModelResponse> getModel(GetModelRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)GetModelRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetModelResponse> getModel(Function<GetModelRequest.Builder, ObjectBuilder<GetModelRequest>> fn) {
        return this.getModel(fn.apply(new GetModelRequest.Builder()).build());
    }

    public CompletableFuture<InferenceResponse> inference(InferenceRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)InferenceRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<InferenceResponse> inference(Function<InferenceRequest.Builder, ObjectBuilder<InferenceRequest>> fn) {
        return this.inference(fn.apply(new InferenceRequest.Builder()).build());
    }

    public CompletableFuture<PutModelResponse> putModel(PutModelRequest request) {
        JsonEndpoint endpoint = (JsonEndpoint)PutModelRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutModelResponse> putModel(Function<PutModelRequest.Builder, ObjectBuilder<PutModelRequest>> fn) {
        return this.putModel(fn.apply(new PutModelRequest.Builder()).build());
    }
}

