/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.ModelSnapshot;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetModelSnapshotsResponse
implements JsonpSerializable {
    private final long count;
    private final List<ModelSnapshot> modelSnapshots;
    public static final JsonpDeserializer<GetModelSnapshotsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetModelSnapshotsResponse::setupGetModelSnapshotsResponseDeserializer);

    private GetModelSnapshotsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.modelSnapshots = ApiTypeHelper.unmodifiableRequired(builder.modelSnapshots, (Object)this, "modelSnapshots");
    }

    public static GetModelSnapshotsResponse of(Function<Builder, ObjectBuilder<GetModelSnapshotsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<ModelSnapshot> modelSnapshots() {
        return this.modelSnapshots;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.modelSnapshots)) {
            generator.writeKey("model_snapshots");
            generator.writeStartArray();
            for (ModelSnapshot item0 : this.modelSnapshots) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetModelSnapshotsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::modelSnapshots, JsonpDeserializer.arrayDeserializer(ModelSnapshot._DESERIALIZER), "model_snapshots");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetModelSnapshotsResponse> {
        private Long count;
        private List<ModelSnapshot> modelSnapshots;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder modelSnapshots(List<ModelSnapshot> list) {
            this.modelSnapshots = Builder._listAddAll(this.modelSnapshots, list);
            return this;
        }

        public final Builder modelSnapshots(ModelSnapshot value, ModelSnapshot ... values) {
            this.modelSnapshots = Builder._listAdd(this.modelSnapshots, value, values);
            return this;
        }

        public final Builder modelSnapshots(Function<ModelSnapshot.Builder, ObjectBuilder<ModelSnapshot>> fn) {
            return this.modelSnapshots(fn.apply(new ModelSnapshot.Builder()).build(), new ModelSnapshot[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetModelSnapshotsResponse build() {
            this._checkSingleUse();
            return new GetModelSnapshotsResponse(this);
        }
    }
}

