/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat.component_templates;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ComponentTemplate
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final String version;
    private final String aliasCount;
    private final String mappingCount;
    private final String settingsCount;
    private final String metadataCount;
    private final String includedIn;
    public static final JsonpDeserializer<ComponentTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ComponentTemplate::setupComponentTemplateDeserializer);

    private ComponentTemplate(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.version = builder.version;
        this.aliasCount = ApiTypeHelper.requireNonNull(builder.aliasCount, this, "aliasCount");
        this.mappingCount = ApiTypeHelper.requireNonNull(builder.mappingCount, this, "mappingCount");
        this.settingsCount = ApiTypeHelper.requireNonNull(builder.settingsCount, this, "settingsCount");
        this.metadataCount = ApiTypeHelper.requireNonNull(builder.metadataCount, this, "metadataCount");
        this.includedIn = ApiTypeHelper.requireNonNull(builder.includedIn, this, "includedIn");
    }

    public static ComponentTemplate of(Function<Builder, ObjectBuilder<ComponentTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    public final String aliasCount() {
        return this.aliasCount;
    }

    public final String mappingCount() {
        return this.mappingCount;
    }

    public final String settingsCount() {
        return this.settingsCount;
    }

    public final String metadataCount() {
        return this.metadataCount;
    }

    public final String includedIn() {
        return this.includedIn;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        generator.writeKey("alias_count");
        generator.write(this.aliasCount);
        generator.writeKey("mapping_count");
        generator.write(this.mappingCount);
        generator.writeKey("settings_count");
        generator.write(this.settingsCount);
        generator.writeKey("metadata_count");
        generator.write(this.metadataCount);
        generator.writeKey("included_in");
        generator.write(this.includedIn);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupComponentTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::aliasCount, JsonpDeserializer.stringDeserializer(), "alias_count");
        op.add(Builder::mappingCount, JsonpDeserializer.stringDeserializer(), "mapping_count");
        op.add(Builder::settingsCount, JsonpDeserializer.stringDeserializer(), "settings_count");
        op.add(Builder::metadataCount, JsonpDeserializer.stringDeserializer(), "metadata_count");
        op.add(Builder::includedIn, JsonpDeserializer.stringDeserializer(), "included_in");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ComponentTemplate> {
        private String name;
        @Nullable
        private String version;
        private String aliasCount;
        private String mappingCount;
        private String settingsCount;
        private String metadataCount;
        private String includedIn;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder aliasCount(String value) {
            this.aliasCount = value;
            return this;
        }

        public final Builder mappingCount(String value) {
            this.mappingCount = value;
            return this;
        }

        public final Builder settingsCount(String value) {
            this.settingsCount = value;
            return this;
        }

        public final Builder metadataCount(String value) {
            this.metadataCount = value;
            return this;
        }

        public final Builder includedIn(String value) {
            this.includedIn = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ComponentTemplate build() {
            this._checkSingleUse();
            return new ComponentTemplate(this);
        }
    }
}

