/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DiskIndicatorDetails
implements JsonpSerializable {
    private final long indicesWithReadonlyBlock;
    private final long nodesWithEnoughDiskSpace;
    private final long nodesOverHighWatermark;
    private final long nodesOverFloodStageWatermark;
    private final long nodesWithUnknownDiskStatus;
    public static final JsonpDeserializer<DiskIndicatorDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiskIndicatorDetails::setupDiskIndicatorDetailsDeserializer);

    private DiskIndicatorDetails(Builder builder) {
        this.indicesWithReadonlyBlock = ApiTypeHelper.requireNonNull(builder.indicesWithReadonlyBlock, (Object)this, "indicesWithReadonlyBlock", 0L);
        this.nodesWithEnoughDiskSpace = ApiTypeHelper.requireNonNull(builder.nodesWithEnoughDiskSpace, (Object)this, "nodesWithEnoughDiskSpace", 0L);
        this.nodesOverHighWatermark = ApiTypeHelper.requireNonNull(builder.nodesOverHighWatermark, (Object)this, "nodesOverHighWatermark", 0L);
        this.nodesOverFloodStageWatermark = ApiTypeHelper.requireNonNull(builder.nodesOverFloodStageWatermark, (Object)this, "nodesOverFloodStageWatermark", 0L);
        this.nodesWithUnknownDiskStatus = ApiTypeHelper.requireNonNull(builder.nodesWithUnknownDiskStatus, (Object)this, "nodesWithUnknownDiskStatus", 0L);
    }

    public static DiskIndicatorDetails of(Function<Builder, ObjectBuilder<DiskIndicatorDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long indicesWithReadonlyBlock() {
        return this.indicesWithReadonlyBlock;
    }

    public final long nodesWithEnoughDiskSpace() {
        return this.nodesWithEnoughDiskSpace;
    }

    public final long nodesOverHighWatermark() {
        return this.nodesOverHighWatermark;
    }

    public final long nodesOverFloodStageWatermark() {
        return this.nodesOverFloodStageWatermark;
    }

    public final long nodesWithUnknownDiskStatus() {
        return this.nodesWithUnknownDiskStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices_with_readonly_block");
        generator.write(this.indicesWithReadonlyBlock);
        generator.writeKey("nodes_with_enough_disk_space");
        generator.write(this.nodesWithEnoughDiskSpace);
        generator.writeKey("nodes_over_high_watermark");
        generator.write(this.nodesOverHighWatermark);
        generator.writeKey("nodes_over_flood_stage_watermark");
        generator.write(this.nodesOverFloodStageWatermark);
        generator.writeKey("nodes_with_unknown_disk_status");
        generator.write(this.nodesWithUnknownDiskStatus);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDiskIndicatorDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indicesWithReadonlyBlock, JsonpDeserializer.longDeserializer(), "indices_with_readonly_block");
        op.add(Builder::nodesWithEnoughDiskSpace, JsonpDeserializer.longDeserializer(), "nodes_with_enough_disk_space");
        op.add(Builder::nodesOverHighWatermark, JsonpDeserializer.longDeserializer(), "nodes_over_high_watermark");
        op.add(Builder::nodesOverFloodStageWatermark, JsonpDeserializer.longDeserializer(), "nodes_over_flood_stage_watermark");
        op.add(Builder::nodesWithUnknownDiskStatus, JsonpDeserializer.longDeserializer(), "nodes_with_unknown_disk_status");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DiskIndicatorDetails> {
        private Long indicesWithReadonlyBlock;
        private Long nodesWithEnoughDiskSpace;
        private Long nodesOverHighWatermark;
        private Long nodesOverFloodStageWatermark;
        private Long nodesWithUnknownDiskStatus;

        public final Builder indicesWithReadonlyBlock(long value) {
            this.indicesWithReadonlyBlock = value;
            return this;
        }

        public final Builder nodesWithEnoughDiskSpace(long value) {
            this.nodesWithEnoughDiskSpace = value;
            return this;
        }

        public final Builder nodesOverHighWatermark(long value) {
            this.nodesOverHighWatermark = value;
            return this;
        }

        public final Builder nodesOverFloodStageWatermark(long value) {
            this.nodesOverFloodStageWatermark = value;
            return this;
        }

        public final Builder nodesWithUnknownDiskStatus(long value) {
            this.nodesWithUnknownDiskStatus = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DiskIndicatorDetails build() {
            this._checkSingleUse();
            return new DiskIndicatorDetails(this);
        }
    }
}

