/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMappingException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class JsonEnums {
    public static <T extends JsonEnum> void serializePipeSeparated(List<T> values, JsonGenerator generator) {
        if (values.size() == 1) {
            generator.write(((JsonEnum)values.get(0)).jsonValue());
        } else {
            generator.write(values.stream().map(JsonEnum::jsonValue).collect(Collectors.joining("|")));
        }
    }

    static class PipeSeparatedDeserializer<T extends JsonEnum>
    extends JsonpDeserializerBase<List<T>> {
        private final JsonEnum.Deserializer<T> enumDeserializer;

        protected PipeSeparatedDeserializer(JsonEnum.Deserializer<T> enumDeserializer) {
            super(EnumSet.of(JsonParser.Event.VALUE_STRING));
            this.enumDeserializer = enumDeserializer;
        }

        @Override
        public List<T> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            String[] values = parser.getString().split("\\|");
            ArrayList result = new ArrayList(values.length);
            for (String v : values) {
                result.add(this.enumDeserializer.deserialize(v.trim(), parser));
            }
            return result;
        }
    }

    public static class Deserializer<T extends JsonEnum>
    extends JsonpDeserializerBase<T> {
        private static final EnumSet<JsonParser.Event> acceptedEvents = EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.KEY_NAME);
        private static final EnumSet<JsonParser.Event> nativeEvents = EnumSet.of(JsonParser.Event.VALUE_STRING);
        private final Map<String, T> lookupTable;

        public Deserializer(T[] values) {
            this((JsonEnum[])values, acceptedEvents);
        }

        protected Deserializer(T[] values, EnumSet<JsonParser.Event> acceptedEvents) {
            super(acceptedEvents, nativeEvents);
            this.lookupTable = new HashMap<String, T>((int)((float)values.length / 0.75f) + 1);
            for (T member : values) {
                String[] aliases;
                String jsonValue = member.jsonValue();
                if (jsonValue != null) {
                    this.lookupTable.put(jsonValue.toLowerCase(), member);
                }
                if ((aliases = member.aliases()) == null) continue;
                for (String alias : aliases) {
                    this.lookupTable.put(alias.toLowerCase(), member);
                }
            }
        }

        @Override
        public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            String value = parser.getString();
            return this.deserialize(value, parser);
        }

        public T deserialize(String value, JsonParser parser) {
            JsonEnum result = (JsonEnum)this.lookupTable.get(value.toLowerCase());
            if (result == null) {
                throw new JsonpMappingException("Invalid enum '" + value + "'", parser.getLocation());
            }
            return (T)result;
        }

        public T parse(String value) {
            JsonEnum result = (JsonEnum)this.lookupTable.get(value.toLowerCase());
            if (result == null) {
                throw new NoSuchElementException("Invalid enum '" + value + "'");
            }
            return (T)result;
        }

        public static class AllowingBooleans<T extends JsonEnum>
        extends JsonEnum.Deserializer<T> {
            private static final EnumSet<JsonParser.Event> acceptedEventsAndBoolean = EnumSet.of(JsonParser.Event.VALUE_STRING, JsonParser.Event.KEY_NAME, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_FALSE);

            public AllowingBooleans(T[] values) {
                super(values, acceptedEventsAndBoolean);
            }

            @Override
            public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                String value = event == JsonParser.Event.VALUE_TRUE ? "true" : (event == JsonParser.Event.VALUE_FALSE ? "false" : parser.getString());
                return this.deserialize(value, parser);
            }
        }
    }
}

